package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ProjectSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractProjectSpecAssert<S extends AbstractProjectSpecAssert<S, A>, A extends ProjectSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProjectSpecAssert}</code> to make assertions on actual ProjectSpec.
   * @param actual the ProjectSpec we want to make assertions on.
   */
  protected AbstractProjectSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ProjectSpec's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ProjectSpec's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProjectSpec's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ProjectSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProjectSpec's finalizers contains the given String elements.
   * @param finalizers the given elements that should be contained in actual ProjectSpec's finalizers.
   * @return this assertion object.
   * @throws AssertionError if the actual ProjectSpec's finalizers does not contain all given String elements.
   */
  public S hasFinalizers(String... finalizers) {
    // check that actual ProjectSpec we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (finalizers == null) failWithMessage("Expecting finalizers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getFinalizers(), finalizers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProjectSpec's finalizers contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param finalizers the given elements that should be contained in actual ProjectSpec's finalizers.
   * @return this assertion object.
   * @throws AssertionError if the actual ProjectSpec's finalizers does not contain all given String elements.
   */
  public S hasOnlyFinalizers(String... finalizers) {
    // check that actual ProjectSpec we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (finalizers == null) failWithMessage("Expecting finalizers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getFinalizers(), finalizers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProjectSpec's finalizers does not contain the given String elements.
   *
   * @param finalizers the given elements that should not be in actual ProjectSpec's finalizers.
   * @return this assertion object.
   * @throws AssertionError if the actual ProjectSpec's finalizers contains any given String elements.
   */
  public S doesNotHaveFinalizers(String... finalizers) {
    // check that actual ProjectSpec we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (finalizers == null) failWithMessage("Expecting finalizers parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getFinalizers(), finalizers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProjectSpec has no finalizers.
   * @return this assertion object.
   * @throws AssertionError if the actual ProjectSpec's finalizers is not empty.
   */
  public S hasNoFinalizers() {
    // check that actual ProjectSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have finalizers but had :\n  <%s>";
    
    // check
    if (actual.getFinalizers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getFinalizers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
