package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RoutePortFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRoutePortFluentImplAssert<S extends AbstractRoutePortFluentImplAssert<S, A>, A extends RoutePortFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRoutePortFluentImplAssert}</code> to make assertions on actual RoutePortFluentImpl.
   * @param actual the RoutePortFluentImpl we want to make assertions on.
   */
  protected AbstractRoutePortFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RoutePortFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual RoutePortFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RoutePortFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual RoutePortFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RoutePortFluentImpl's targetPort is equal to the given one.
   * @param targetPort the given targetPort to compare the actual RoutePortFluentImpl's targetPort to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RoutePortFluentImpl's targetPort is not equal to the given one.
   */
  public S hasTargetPort(io.fabric8.kubernetes.api.model.IntOrString targetPort) {
    // check that actual RoutePortFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting targetPort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.IntOrString actualTargetPort = actual.getTargetPort();
    if (!Objects.areEqual(actualTargetPort, targetPort)) {
      failWithMessage(assertjErrorMessage, actual, targetPort, actualTargetPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
