
                                          

package io.fabric8.kubernetes.client.handlers.settings.v1alpha1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.settings.v1alpha1.PodPresetOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.settings.PodPreset;
import io.fabric8.kubernetes.api.model.settings.PodPresetBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PodPresetHandler implements ResourceHandler<PodPreset, PodPresetBuilder> {

  @Override
  public String getKind() {
    return PodPreset.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "settings.k8s.io/v1alpha1";
      }

  @Override
  public PodPreset create(OkHttpClient client, Config config, String namespace, PodPreset item) {
    return new PodPresetOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public PodPreset replace(OkHttpClient client, Config config, String namespace, PodPreset item) {
    return new PodPresetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public PodPreset reload(OkHttpClient client, Config config, String namespace, PodPreset item) {
    return new PodPresetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public PodPresetBuilder edit(PodPreset item) {
    return new PodPresetBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, PodPreset item) {
    return new PodPresetOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodPreset item, Watcher<PodPreset> watcher) {
    return new PodPresetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodPreset item, String resourceVersion, Watcher<PodPreset> watcher) {
    return new PodPresetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodPreset item, ListOptions options, Watcher<PodPreset> watcher) {
    return new PodPresetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public PodPreset waitUntilReady(OkHttpClient client, Config config, String namespace, PodPreset item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PodPresetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public PodPreset waitUntilCondition(OkHttpClient client, Config config, String namespace, PodPreset item, Predicate<PodPreset> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PodPresetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
