
                                          
  

package io.fabric8.kubernetes.client.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceList;

import java.util.Map;
import java.util.TreeMap;


public class NamespaceOperationsImpl extends HasMetadataOperation<Namespace, NamespaceList, Resource<Namespace>> {

  public NamespaceOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public NamespaceOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public NamespaceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("")
    .withApiGroupVersion("v1")
    .withPlural("namespaces"));
    this.type = Namespace.class;
    this.listType = NamespaceList.class;
  }

  public NamespaceOperationsImpl newInstance(OperationContext context) {
    return new NamespaceOperationsImpl(context);
  }

  @Override
  public Namespace edit(Visitor... visitors) {
    return patch(new NamespaceBuilder(getMandatory()).accept(visitors).build());
  }

  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
