
                                          

package io.fabric8.kubernetes.client.handlers.policy.v1beta1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.policy.v1beta1.PodDisruptionBudgetOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.policy.PodDisruptionBudget;
import io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PodDisruptionBudgetHandler implements ResourceHandler<PodDisruptionBudget, PodDisruptionBudgetBuilder> {

  @Override
  public String getKind() {
    return PodDisruptionBudget.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "policy/v1beta1";
      }

  @Override
  public PodDisruptionBudget create(OkHttpClient client, Config config, String namespace, PodDisruptionBudget item) {
    return new PodDisruptionBudgetOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public PodDisruptionBudget replace(OkHttpClient client, Config config, String namespace, PodDisruptionBudget item) {
    return new PodDisruptionBudgetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public PodDisruptionBudget reload(OkHttpClient client, Config config, String namespace, PodDisruptionBudget item) {
    return new PodDisruptionBudgetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public PodDisruptionBudgetBuilder edit(PodDisruptionBudget item) {
    return new PodDisruptionBudgetBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, PodDisruptionBudget item) {
    return new PodDisruptionBudgetOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodDisruptionBudget item, Watcher<PodDisruptionBudget> watcher) {
    return new PodDisruptionBudgetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodDisruptionBudget item, String resourceVersion, Watcher<PodDisruptionBudget> watcher) {
    return new PodDisruptionBudgetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodDisruptionBudget item, ListOptions options, Watcher<PodDisruptionBudget> watcher) {
    return new PodDisruptionBudgetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public PodDisruptionBudget waitUntilReady(OkHttpClient client, Config config, String namespace, PodDisruptionBudget item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PodDisruptionBudgetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public PodDisruptionBudget waitUntilCondition(OkHttpClient client, Config config, String namespace, PodDisruptionBudget item, Predicate<PodDisruptionBudget> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PodDisruptionBudgetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
