/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.junit.jupiter;

import io.fabric8.junit.jupiter.KubernetesNamespacedTestExtension;
import io.fabric8.junit.jupiter.api.LoadKubernetesManifests;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.PropagationPolicyConfigurable;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class LoadKubernetesManifestsExtension
implements BeforeAllCallback,
AfterAllCallback {
    public void beforeAll(ExtensionContext context) {
        LoadKubernetesManifests annotation = context.getRequiredTestClass().getAnnotation(LoadKubernetesManifests.class);
        KubernetesClient kc = KubernetesNamespacedTestExtension.getClient(context);
        for (String resource : annotation.value()) {
            kc.load(context.getRequiredTestClass().getResourceAsStream(resource)).create();
        }
    }

    public void afterAll(ExtensionContext context) {
        LoadKubernetesManifests annotation = context.getRequiredTestClass().getAnnotation(LoadKubernetesManifests.class);
        if (annotation.deleteAfterTest()) {
            KubernetesClient kc = KubernetesNamespacedTestExtension.getClient(context);
            for (String resource : annotation.value()) {
                ((PropagationPolicyConfigurable)kc.load(context.getRequiredTestClass().getResourceAsStream(resource)).withGracePeriod(annotation.deleteGracePeriod())).delete();
            }
        }
    }
}

