package io.fabric8.kubernetes.api.model.batch.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CronJobSpecBuilder extends CronJobSpecFluentImpl<CronJobSpecBuilder> implements VisitableBuilder<CronJobSpec,CronJobSpecBuilder>{
  public CronJobSpecBuilder() {
    this(false);
  }
  public CronJobSpecBuilder(Boolean validationEnabled) {
    this(new CronJobSpec(), validationEnabled);
  }
  public CronJobSpecBuilder(CronJobSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CronJobSpecBuilder(CronJobSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CronJobSpec(), validationEnabled);
  }
  public CronJobSpecBuilder(CronJobSpecFluent<?> fluent,CronJobSpec instance) {
    this(fluent, instance, false);
  }
  public CronJobSpecBuilder(CronJobSpecFluent<?> fluent,CronJobSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConcurrencyPolicy(instance.getConcurrencyPolicy());
      fluent.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());
      fluent.withJobTemplate(instance.getJobTemplate());
      fluent.withSchedule(instance.getSchedule());
      fluent.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());
      fluent.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());
      fluent.withSuspend(instance.getSuspend());
      fluent.withTimeZone(instance.getTimeZone());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CronJobSpecBuilder(CronJobSpec instance) {
    this(instance,false);
  }
  public CronJobSpecBuilder(CronJobSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConcurrencyPolicy(instance.getConcurrencyPolicy());
      this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());
      this.withJobTemplate(instance.getJobTemplate());
      this.withSchedule(instance.getSchedule());
      this.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());
      this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());
      this.withSuspend(instance.getSuspend());
      this.withTimeZone(instance.getTimeZone());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CronJobSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CronJobSpec build() {
    CronJobSpec buildable = new CronJobSpec(fluent.getConcurrencyPolicy(),fluent.getFailedJobsHistoryLimit(),fluent.getJobTemplate(),fluent.getSchedule(),fluent.getStartingDeadlineSeconds(),fluent.getSuccessfulJobsHistoryLimit(),fluent.getSuspend(),fluent.getTimeZone());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}