package io.fabric8.kubernetes.api.model.batch.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JobTemplateSpecBuilder extends JobTemplateSpecFluentImpl<JobTemplateSpecBuilder> implements VisitableBuilder<JobTemplateSpec,JobTemplateSpecBuilder>{
  public JobTemplateSpecBuilder() {
    this(false);
  }
  public JobTemplateSpecBuilder(Boolean validationEnabled) {
    this(new JobTemplateSpec(), validationEnabled);
  }
  public JobTemplateSpecBuilder(JobTemplateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public JobTemplateSpecBuilder(JobTemplateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JobTemplateSpec(), validationEnabled);
  }
  public JobTemplateSpecBuilder(JobTemplateSpecFluent<?> fluent,JobTemplateSpec instance) {
    this(fluent, instance, false);
  }
  public JobTemplateSpecBuilder(JobTemplateSpecFluent<?> fluent,JobTemplateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JobTemplateSpecBuilder(JobTemplateSpec instance) {
    this(instance,false);
  }
  public JobTemplateSpecBuilder(JobTemplateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  JobTemplateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public JobTemplateSpec build() {
    JobTemplateSpec buildable = new JobTemplateSpec(fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}