/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource;
import io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.SecretReference;
import io.fabric8.kubernetes.api.model.SecretReferenceBuilder;
import io.fabric8.kubernetes.api.model.SecretReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;

public class CSIPersistentVolumeSourceFluentImpl<A extends CSIPersistentVolumeSourceFluent<A>>
extends BaseFluent<A>
implements CSIPersistentVolumeSourceFluent<A> {
    private SecretReferenceBuilder controllerExpandSecretRef;
    private SecretReferenceBuilder controllerPublishSecretRef;
    private String driver;
    private String fsType;
    private SecretReferenceBuilder nodePublishSecretRef;
    private SecretReferenceBuilder nodeStageSecretRef;
    private Boolean readOnly;
    private Map<String, String> volumeAttributes;
    private String volumeHandle;

    public CSIPersistentVolumeSourceFluentImpl() {
    }

    public CSIPersistentVolumeSourceFluentImpl(CSIPersistentVolumeSource instance) {
        this.withControllerExpandSecretRef(instance.getControllerExpandSecretRef());
        this.withControllerPublishSecretRef(instance.getControllerPublishSecretRef());
        this.withDriver(instance.getDriver());
        this.withFsType(instance.getFsType());
        this.withNodePublishSecretRef(instance.getNodePublishSecretRef());
        this.withNodeStageSecretRef(instance.getNodeStageSecretRef());
        this.withReadOnly(instance.getReadOnly());
        this.withVolumeAttributes(instance.getVolumeAttributes());
        this.withVolumeHandle(instance.getVolumeHandle());
    }

    @Override
    @Deprecated
    public SecretReference getControllerExpandSecretRef() {
        return this.controllerExpandSecretRef != null ? this.controllerExpandSecretRef.build() : null;
    }

    @Override
    public SecretReference buildControllerExpandSecretRef() {
        return this.controllerExpandSecretRef != null ? this.controllerExpandSecretRef.build() : null;
    }

    @Override
    public A withControllerExpandSecretRef(SecretReference controllerExpandSecretRef) {
        this._visitables.get("controllerExpandSecretRef").remove(this.controllerExpandSecretRef);
        if (controllerExpandSecretRef != null) {
            this.controllerExpandSecretRef = new SecretReferenceBuilder(controllerExpandSecretRef);
            this._visitables.get("controllerExpandSecretRef").add(this.controllerExpandSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasControllerExpandSecretRef() {
        return this.controllerExpandSecretRef != null;
    }

    @Override
    public A withNewControllerExpandSecretRef(String name, String namespace) {
        return this.withControllerExpandSecretRef(new SecretReference(name, namespace));
    }

    @Override
    public CSIPersistentVolumeSourceFluent.ControllerExpandSecretRefNested<A> withNewControllerExpandSecretRef() {
        return new ControllerExpandSecretRefNestedImpl();
    }

    @Override
    public CSIPersistentVolumeSourceFluent.ControllerExpandSecretRefNested<A> withNewControllerExpandSecretRefLike(SecretReference item) {
        return new ControllerExpandSecretRefNestedImpl(item);
    }

    @Override
    public CSIPersistentVolumeSourceFluent.ControllerExpandSecretRefNested<A> editControllerExpandSecretRef() {
        return this.withNewControllerExpandSecretRefLike(this.getControllerExpandSecretRef());
    }

    @Override
    public CSIPersistentVolumeSourceFluent.ControllerExpandSecretRefNested<A> editOrNewControllerExpandSecretRef() {
        return this.withNewControllerExpandSecretRefLike(this.getControllerExpandSecretRef() != null ? this.getControllerExpandSecretRef() : new SecretReferenceBuilder().build());
    }

    @Override
    public CSIPersistentVolumeSourceFluent.ControllerExpandSecretRefNested<A> editOrNewControllerExpandSecretRefLike(SecretReference item) {
        return this.withNewControllerExpandSecretRefLike(this.getControllerExpandSecretRef() != null ? this.getControllerExpandSecretRef() : item);
    }

    @Override
    @Deprecated
    public SecretReference getControllerPublishSecretRef() {
        return this.controllerPublishSecretRef != null ? this.controllerPublishSecretRef.build() : null;
    }

    @Override
    public SecretReference buildControllerPublishSecretRef() {
        return this.controllerPublishSecretRef != null ? this.controllerPublishSecretRef.build() : null;
    }

    @Override
    public A withControllerPublishSecretRef(SecretReference controllerPublishSecretRef) {
        this._visitables.get("controllerPublishSecretRef").remove(this.controllerPublishSecretRef);
        if (controllerPublishSecretRef != null) {
            this.controllerPublishSecretRef = new SecretReferenceBuilder(controllerPublishSecretRef);
            this._visitables.get("controllerPublishSecretRef").add(this.controllerPublishSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasControllerPublishSecretRef() {
        return this.controllerPublishSecretRef != null;
    }

    @Override
    public A withNewControllerPublishSecretRef(String name, String namespace) {
        return this.withControllerPublishSecretRef(new SecretReference(name, namespace));
    }

    @Override
    public CSIPersistentVolumeSourceFluent.ControllerPublishSecretRefNested<A> withNewControllerPublishSecretRef() {
        return new ControllerPublishSecretRefNestedImpl();
    }

    @Override
    public CSIPersistentVolumeSourceFluent.ControllerPublishSecretRefNested<A> withNewControllerPublishSecretRefLike(SecretReference item) {
        return new ControllerPublishSecretRefNestedImpl(item);
    }

    @Override
    public CSIPersistentVolumeSourceFluent.ControllerPublishSecretRefNested<A> editControllerPublishSecretRef() {
        return this.withNewControllerPublishSecretRefLike(this.getControllerPublishSecretRef());
    }

    @Override
    public CSIPersistentVolumeSourceFluent.ControllerPublishSecretRefNested<A> editOrNewControllerPublishSecretRef() {
        return this.withNewControllerPublishSecretRefLike(this.getControllerPublishSecretRef() != null ? this.getControllerPublishSecretRef() : new SecretReferenceBuilder().build());
    }

    @Override
    public CSIPersistentVolumeSourceFluent.ControllerPublishSecretRefNested<A> editOrNewControllerPublishSecretRefLike(SecretReference item) {
        return this.withNewControllerPublishSecretRefLike(this.getControllerPublishSecretRef() != null ? this.getControllerPublishSecretRef() : item);
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    @Override
    public Boolean hasDriver() {
        return this.driver != null;
    }

    @Override
    public A withNewDriver(String arg1) {
        return this.withDriver(new String(arg1));
    }

    @Override
    public A withNewDriver(StringBuilder arg1) {
        return this.withDriver(new String(arg1));
    }

    @Override
    public A withNewDriver(StringBuffer arg1) {
        return this.withDriver(new String(arg1));
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public A withNewFsType(String arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A withNewFsType(StringBuilder arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A withNewFsType(StringBuffer arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    @Deprecated
    public SecretReference getNodePublishSecretRef() {
        return this.nodePublishSecretRef != null ? this.nodePublishSecretRef.build() : null;
    }

    @Override
    public SecretReference buildNodePublishSecretRef() {
        return this.nodePublishSecretRef != null ? this.nodePublishSecretRef.build() : null;
    }

    @Override
    public A withNodePublishSecretRef(SecretReference nodePublishSecretRef) {
        this._visitables.get("nodePublishSecretRef").remove(this.nodePublishSecretRef);
        if (nodePublishSecretRef != null) {
            this.nodePublishSecretRef = new SecretReferenceBuilder(nodePublishSecretRef);
            this._visitables.get("nodePublishSecretRef").add(this.nodePublishSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodePublishSecretRef() {
        return this.nodePublishSecretRef != null;
    }

    @Override
    public A withNewNodePublishSecretRef(String name, String namespace) {
        return this.withNodePublishSecretRef(new SecretReference(name, namespace));
    }

    @Override
    public CSIPersistentVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRef() {
        return new NodePublishSecretRefNestedImpl();
    }

    @Override
    public CSIPersistentVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRefLike(SecretReference item) {
        return new NodePublishSecretRefNestedImpl(item);
    }

    @Override
    public CSIPersistentVolumeSourceFluent.NodePublishSecretRefNested<A> editNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(this.getNodePublishSecretRef());
    }

    @Override
    public CSIPersistentVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(this.getNodePublishSecretRef() != null ? this.getNodePublishSecretRef() : new SecretReferenceBuilder().build());
    }

    @Override
    public CSIPersistentVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRefLike(SecretReference item) {
        return this.withNewNodePublishSecretRefLike(this.getNodePublishSecretRef() != null ? this.getNodePublishSecretRef() : item);
    }

    @Override
    @Deprecated
    public SecretReference getNodeStageSecretRef() {
        return this.nodeStageSecretRef != null ? this.nodeStageSecretRef.build() : null;
    }

    @Override
    public SecretReference buildNodeStageSecretRef() {
        return this.nodeStageSecretRef != null ? this.nodeStageSecretRef.build() : null;
    }

    @Override
    public A withNodeStageSecretRef(SecretReference nodeStageSecretRef) {
        this._visitables.get("nodeStageSecretRef").remove(this.nodeStageSecretRef);
        if (nodeStageSecretRef != null) {
            this.nodeStageSecretRef = new SecretReferenceBuilder(nodeStageSecretRef);
            this._visitables.get("nodeStageSecretRef").add(this.nodeStageSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodeStageSecretRef() {
        return this.nodeStageSecretRef != null;
    }

    @Override
    public A withNewNodeStageSecretRef(String name, String namespace) {
        return this.withNodeStageSecretRef(new SecretReference(name, namespace));
    }

    @Override
    public CSIPersistentVolumeSourceFluent.NodeStageSecretRefNested<A> withNewNodeStageSecretRef() {
        return new NodeStageSecretRefNestedImpl();
    }

    @Override
    public CSIPersistentVolumeSourceFluent.NodeStageSecretRefNested<A> withNewNodeStageSecretRefLike(SecretReference item) {
        return new NodeStageSecretRefNestedImpl(item);
    }

    @Override
    public CSIPersistentVolumeSourceFluent.NodeStageSecretRefNested<A> editNodeStageSecretRef() {
        return this.withNewNodeStageSecretRefLike(this.getNodeStageSecretRef());
    }

    @Override
    public CSIPersistentVolumeSourceFluent.NodeStageSecretRefNested<A> editOrNewNodeStageSecretRef() {
        return this.withNewNodeStageSecretRefLike(this.getNodeStageSecretRef() != null ? this.getNodeStageSecretRef() : new SecretReferenceBuilder().build());
    }

    @Override
    public CSIPersistentVolumeSourceFluent.NodeStageSecretRefNested<A> editOrNewNodeStageSecretRefLike(SecretReference item) {
        return this.withNewNodeStageSecretRefLike(this.getNodeStageSecretRef() != null ? this.getNodeStageSecretRef() : item);
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public A withNewReadOnly(String arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    public A withNewReadOnly(boolean arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    public A addToVolumeAttributes(String key, String value) {
        if (this.volumeAttributes == null && key != null && value != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.volumeAttributes.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null && map != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.volumeAttributes.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeAttributes(String key) {
        if (this.volumeAttributes == null) {
            return (A)this;
        }
        if (key != null && this.volumeAttributes != null) {
            this.volumeAttributes.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.volumeAttributes == null) continue;
                this.volumeAttributes.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getVolumeAttributes() {
        return this.volumeAttributes;
    }

    @Override
    public A withVolumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes == null ? null : new LinkedHashMap<String, String>(volumeAttributes);
        return (A)this;
    }

    @Override
    public Boolean hasVolumeAttributes() {
        return this.volumeAttributes != null;
    }

    @Override
    public String getVolumeHandle() {
        return this.volumeHandle;
    }

    @Override
    public A withVolumeHandle(String volumeHandle) {
        this.volumeHandle = volumeHandle;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeHandle() {
        return this.volumeHandle != null;
    }

    @Override
    public A withNewVolumeHandle(String arg1) {
        return this.withVolumeHandle(new String(arg1));
    }

    @Override
    public A withNewVolumeHandle(StringBuilder arg1) {
        return this.withVolumeHandle(new String(arg1));
    }

    @Override
    public A withNewVolumeHandle(StringBuffer arg1) {
        return this.withVolumeHandle(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CSIPersistentVolumeSourceFluentImpl that = (CSIPersistentVolumeSourceFluentImpl)o;
        if (this.controllerExpandSecretRef != null ? !this.controllerExpandSecretRef.equals(that.controllerExpandSecretRef) : that.controllerExpandSecretRef != null) {
            return false;
        }
        if (this.controllerPublishSecretRef != null ? !this.controllerPublishSecretRef.equals(that.controllerPublishSecretRef) : that.controllerPublishSecretRef != null) {
            return false;
        }
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.nodePublishSecretRef != null ? !this.nodePublishSecretRef.equals(that.nodePublishSecretRef) : that.nodePublishSecretRef != null) {
            return false;
        }
        if (this.nodeStageSecretRef != null ? !this.nodeStageSecretRef.equals(that.nodeStageSecretRef) : that.nodeStageSecretRef != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.volumeAttributes != null ? !this.volumeAttributes.equals(that.volumeAttributes) : that.volumeAttributes != null) {
            return false;
        }
        return !(this.volumeHandle != null ? !this.volumeHandle.equals(that.volumeHandle) : that.volumeHandle != null);
    }

    public class NodeStageSecretRefNestedImpl<N>
    extends SecretReferenceFluentImpl<CSIPersistentVolumeSourceFluent.NodeStageSecretRefNested<N>>
    implements CSIPersistentVolumeSourceFluent.NodeStageSecretRefNested<N>,
    Nested<N> {
        private final SecretReferenceBuilder builder;

        NodeStageSecretRefNestedImpl(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        NodeStageSecretRefNestedImpl() {
            this.builder = new SecretReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CSIPersistentVolumeSourceFluentImpl.this.withNodeStageSecretRef(this.builder.build());
        }

        @Override
        public N endNodeStageSecretRef() {
            return this.and();
        }
    }

    public class NodePublishSecretRefNestedImpl<N>
    extends SecretReferenceFluentImpl<CSIPersistentVolumeSourceFluent.NodePublishSecretRefNested<N>>
    implements CSIPersistentVolumeSourceFluent.NodePublishSecretRefNested<N>,
    Nested<N> {
        private final SecretReferenceBuilder builder;

        NodePublishSecretRefNestedImpl(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        NodePublishSecretRefNestedImpl() {
            this.builder = new SecretReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CSIPersistentVolumeSourceFluentImpl.this.withNodePublishSecretRef(this.builder.build());
        }

        @Override
        public N endNodePublishSecretRef() {
            return this.and();
        }
    }

    public class ControllerPublishSecretRefNestedImpl<N>
    extends SecretReferenceFluentImpl<CSIPersistentVolumeSourceFluent.ControllerPublishSecretRefNested<N>>
    implements CSIPersistentVolumeSourceFluent.ControllerPublishSecretRefNested<N>,
    Nested<N> {
        private final SecretReferenceBuilder builder;

        ControllerPublishSecretRefNestedImpl(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        ControllerPublishSecretRefNestedImpl() {
            this.builder = new SecretReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CSIPersistentVolumeSourceFluentImpl.this.withControllerPublishSecretRef(this.builder.build());
        }

        @Override
        public N endControllerPublishSecretRef() {
            return this.and();
        }
    }

    public class ControllerExpandSecretRefNestedImpl<N>
    extends SecretReferenceFluentImpl<CSIPersistentVolumeSourceFluent.ControllerExpandSecretRefNested<N>>
    implements CSIPersistentVolumeSourceFluent.ControllerExpandSecretRefNested<N>,
    Nested<N> {
        private final SecretReferenceBuilder builder;

        ControllerExpandSecretRefNestedImpl(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        ControllerExpandSecretRefNestedImpl() {
            this.builder = new SecretReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CSIPersistentVolumeSourceFluentImpl.this.withControllerExpandSecretRef(this.builder.build());
        }

        @Override
        public N endControllerExpandSecretRef() {
            return this.and();
        }
    }
}

