package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressTLSBuilder extends IngressTLSFluentImpl<IngressTLSBuilder> implements VisitableBuilder<IngressTLS,IngressTLSBuilder>{
  public IngressTLSBuilder() {
    this(false);
  }
  public IngressTLSBuilder(Boolean validationEnabled) {
    this(new IngressTLS(), validationEnabled);
  }
  public IngressTLSBuilder(IngressTLSFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressTLSBuilder(IngressTLSFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressTLS(), validationEnabled);
  }
  public IngressTLSBuilder(IngressTLSFluent<?> fluent,IngressTLS instance) {
    this(fluent, instance, false);
  }
  public IngressTLSBuilder(IngressTLSFluent<?> fluent,IngressTLS instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHosts(instance.getHosts()); 
    fluent.withSecretName(instance.getSecretName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressTLSBuilder(IngressTLS instance) {
    this(instance,false);
  }
  public IngressTLSBuilder(IngressTLS instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withHosts(instance.getHosts()); 
    this.withSecretName(instance.getSecretName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IngressTLSFluent<?> fluent;
  Boolean validationEnabled;
  public IngressTLS build() {
    IngressTLS buildable = new IngressTLS(fluent.getHosts(),fluent.getSecretName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}