package io.fabric8.kubernetes.api.model.networking.v1alpha1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.NodeSelector;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterCIDRSpecFluentImpl<A extends ClusterCIDRSpecFluent<A>> extends BaseFluent<A> implements ClusterCIDRSpecFluent<A>{
  public ClusterCIDRSpecFluentImpl() {
  }
  public ClusterCIDRSpecFluentImpl(ClusterCIDRSpec instance) {
    this.withIpv4(instance.getIpv4()); 
    this.withIpv6(instance.getIpv6()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withPerNodeHostBits(instance.getPerNodeHostBits()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String ipv4;
  private String ipv6;
  private NodeSelector nodeSelector;
  private Integer perNodeHostBits;
  private Map<String,Object> additionalProperties;
  public String getIpv4() {
    return this.ipv4;
  }
  public A withIpv4(String ipv4) {
    this.ipv4=ipv4; return (A) this;
  }
  public Boolean hasIpv4() {
    return this.ipv4 != null;
  }
  public String getIpv6() {
    return this.ipv6;
  }
  public A withIpv6(String ipv6) {
    this.ipv6=ipv6; return (A) this;
  }
  public Boolean hasIpv6() {
    return this.ipv6 != null;
  }
  public NodeSelector getNodeSelector() {
    return this.nodeSelector;
  }
  public A withNodeSelector(NodeSelector nodeSelector) {
    this.nodeSelector=nodeSelector; return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  public Integer getPerNodeHostBits() {
    return this.perNodeHostBits;
  }
  public A withPerNodeHostBits(Integer perNodeHostBits) {
    this.perNodeHostBits=perNodeHostBits; return (A) this;
  }
  public Boolean hasPerNodeHostBits() {
    return this.perNodeHostBits != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterCIDRSpecFluentImpl that = (ClusterCIDRSpecFluentImpl) o;
    if (ipv4 != null ? !ipv4.equals(that.ipv4) :that.ipv4 != null) return false;
    if (ipv6 != null ? !ipv6.equals(that.ipv6) :that.ipv6 != null) return false;
    if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
    if (perNodeHostBits != null ? !perNodeHostBits.equals(that.perNodeHostBits) :that.perNodeHostBits != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ipv4,  ipv6,  nodeSelector,  perNodeHostBits,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ipv4 != null) { sb.append("ipv4:"); sb.append(ipv4 + ","); }
    if (ipv6 != null) { sb.append("ipv6:"); sb.append(ipv6 + ","); }
    if (nodeSelector != null) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (perNodeHostBits != null) { sb.append("perNodeHostBits:"); sb.append(perNodeHostBits + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}