/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.mock;

import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.server.mock.Returnable;
import io.fabric8.kubernetes.server.mock.Timeable;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildConfigListBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import io.fabric8.openshift.client.mock.OpenShiftMockServerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class BuildConfigTest
extends OpenShiftMockServerTestBase {
    @Test
    public void testList() {
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/namespaces/test/buildconfigs")).andReturn(200, (Object)new BuildConfigListBuilder().build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/namespaces/ns1/buildconfigs")).andReturn(200, (Object)((BuildConfigListBuilder)((BuildConfigListBuilder)new BuildConfigListBuilder().addNewItem().and()).addNewItem().and()).build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/buildconfigs")).andReturn(200, (Object)((BuildConfigListBuilder)((BuildConfigListBuilder)((BuildConfigListBuilder)new BuildConfigListBuilder().addNewItem().and()).addNewItem().and()).addNewItem().and()).build())).once();
        OpenShiftClient client = this.getOpenshiftClient();
        BuildConfigList buildConfigList = (BuildConfigList)client.buildConfigs().list();
        Assert.assertNotNull((Object)buildConfigList);
        Assert.assertEquals((long)0L, (long)buildConfigList.getItems().size());
        buildConfigList = (BuildConfigList)((ClientNonNamespaceOperation)client.buildConfigs().inNamespace("ns1")).list();
        Assert.assertNotNull((Object)buildConfigList);
        Assert.assertEquals((long)2L, (long)buildConfigList.getItems().size());
        buildConfigList = (BuildConfigList)((FilterWatchListMultiDeletable)client.buildConfigs().inAnyNamespace()).list();
        Assert.assertNotNull((Object)buildConfigList);
        Assert.assertEquals((long)3L, (long)buildConfigList.getItems().size());
    }

    @Test
    public void testGet() {
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/namespaces/test/buildconfigs/bc1")).andReturn(200, (Object)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName("bc1")).endMetadata()).build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/namespaces/ns1/buildconfigs/bc2")).andReturn(200, (Object)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName("bc2")).endMetadata()).build())).once();
        OpenShiftClient client = this.getOpenshiftClient();
        BuildConfig buildConfig = (BuildConfig)((ClientBuildConfigResource)client.buildConfigs().withName("bc1")).get();
        Assert.assertNotNull((Object)buildConfig);
        Assert.assertEquals((Object)"bc1", (Object)buildConfig.getMetadata().getName());
        buildConfig = (BuildConfig)((ClientBuildConfigResource)client.buildConfigs().withName("bc2")).get();
        Assert.assertNull((Object)buildConfig);
        buildConfig = (BuildConfig)((ClientBuildConfigResource)((ClientNonNamespaceOperation)client.buildConfigs().inNamespace("ns1")).withName("bc2")).get();
        Assert.assertNotNull((Object)buildConfig);
        Assert.assertEquals((Object)"bc2", (Object)buildConfig.getMetadata().getName());
    }

    @Test
    public void testDelete() {
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/namespaces/test/buildconfigs/bc1")).andReturn(200, (Object)new BuildConfigBuilder().build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/namespaces/ns1/buildconfigs/bc2")).andReturn(200, (Object)new BuildConfigBuilder().build())).once();
        OpenShiftClient client = this.getOpenshiftClient();
        Boolean deleted = (Boolean)((ClientBuildConfigResource)client.buildConfigs().withName("bc1")).delete();
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((ClientBuildConfigResource)client.buildConfigs().withName("bc2")).delete();
        Assert.assertFalse((boolean)deleted);
        deleted = (Boolean)((ClientBuildConfigResource)((ClientNonNamespaceOperation)client.buildConfigs().inNamespace("ns1")).withName("bc2")).delete();
        Assert.assertTrue((boolean)deleted);
    }
}

