/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.mock;

import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.server.mock.Returnable;
import io.fabric8.kubernetes.server.mock.Timeable;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.api.model.TemplateListBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.ParameterValue;
import io.fabric8.openshift.client.dsl.ClientTemplateResource;
import io.fabric8.openshift.client.mock.OpenShiftMockServerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class TemplateTest
extends OpenShiftMockServerTestBase {
    @Test
    public void testList() {
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/namespaces/test/templates")).andReturn(200, (Object)new TemplateListBuilder().build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/namespaces/ns1/templates")).andReturn(200, (Object)((TemplateListBuilder)((TemplateListBuilder)new TemplateListBuilder().addNewItem().and()).addNewItem().and()).build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/templates")).andReturn(200, (Object)((TemplateListBuilder)((TemplateListBuilder)((TemplateListBuilder)new TemplateListBuilder().addNewItem().and()).addNewItem().and()).addNewItem().and()).build())).once();
        OpenShiftClient client = this.getOpenshiftClient();
        TemplateList templateList = (TemplateList)client.templates().list();
        Assert.assertNotNull((Object)templateList);
        Assert.assertEquals((long)0L, (long)templateList.getItems().size());
        templateList = (TemplateList)((ClientNonNamespaceOperation)client.templates().inNamespace("ns1")).list();
        Assert.assertNotNull((Object)templateList);
        Assert.assertEquals((long)2L, (long)templateList.getItems().size());
        templateList = (TemplateList)((FilterWatchListMultiDeletable)client.templates().inAnyNamespace()).list();
        Assert.assertNotNull((Object)templateList);
        Assert.assertEquals((long)3L, (long)templateList.getItems().size());
    }

    @Test
    public void testGet() {
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/namespaces/test/templates/tmpl1")).andReturn(200, (Object)((TemplateBuilder)((TemplateFluent.MetadataNested)new TemplateBuilder().withNewMetadata().withName("tmpl1")).endMetadata()).build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/namespaces/ns1/templates/tmpl2")).andReturn(200, (Object)((TemplateBuilder)((TemplateFluent.MetadataNested)new TemplateBuilder().withNewMetadata().withName("tmpl2")).endMetadata()).build())).once();
        OpenShiftClient client = this.getOpenshiftClient();
        Template template = (Template)((ClientTemplateResource)client.templates().withName("tmpl1")).get();
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)"tmpl1", (Object)template.getMetadata().getName());
        template = (Template)((ClientTemplateResource)client.templates().withName("tmpl2")).get();
        Assert.assertNull((Object)template);
        template = (Template)((ClientTemplateResource)((ClientNonNamespaceOperation)client.templates().inNamespace("ns1")).withName("tmpl2")).get();
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)"tmpl2", (Object)template.getMetadata().getName());
    }

    @Test
    public void testDelete() {
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/namespaces/test/templates/tmpl1")).andReturn(200, (Object)new TemplateBuilder().build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/namespaces/ns1/templates/tmpl2")).andReturn(200, (Object)new TemplateBuilder().build())).once();
        OpenShiftClient client = this.getOpenshiftClient();
        Boolean deleted = (Boolean)((ClientTemplateResource)client.templates().withName("tmpl1")).delete();
        Assert.assertNotNull((Object)deleted);
        deleted = (Boolean)((ClientTemplateResource)client.templates().withName("tmpl2")).delete();
        Assert.assertFalse((boolean)deleted);
        deleted = (Boolean)((ClientTemplateResource)((ClientNonNamespaceOperation)client.templates().inNamespace("ns1")).withName("tmpl2")).delete();
        Assert.assertTrue((boolean)deleted);
    }

    @Test
    public void testProcess() {
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/namespaces/test/templates/tmpl1")).andReturn(200, (Object)new TemplateBuilder().build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/oapi/v1/namespaces/test/processedtemplates")).andReturn(201, (Object)new KubernetesListBuilder().build())).once();
        OpenShiftClient client = this.getOpenshiftClient();
        KubernetesList list = (KubernetesList)((ClientTemplateResource)client.templates().withName("tmpl1")).process(new ParameterValue[]{new ParameterValue("name1", "value1")});
        Assert.assertNotNull((Object)list);
    }
}

