/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AdaptTest {
    AdaptTest() {
    }

    @Test
    void testAdaptDisabledCheck() {
        OpenShiftClient client = (OpenShiftClient)new KubernetesClientBuilder().withConfig((Config)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withDisableApiGroupCheck(true)).build()).build().adapt(OpenShiftClient.class);
        Assertions.assertTrue((boolean)client.isAdaptable(OpenShiftClient.class));
    }

    @Test
    void testAdaptDSLs() {
        OpenShiftClient client = (OpenShiftClient)new KubernetesClientBuilder().withConfig((Config)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withDisableApiGroupCheck(true)).build()).build().adapt(OpenShiftClient.class);
        Assertions.assertNotNull((Object)client.v1());
        Assertions.assertNotNull((Object)client.apps());
        Assertions.assertNotNull((Object)client.autoscaling());
        Assertions.assertNotNull((Object)client.batch());
        Assertions.assertNotNull((Object)client.buildConfigs());
        Assertions.assertNotNull((Object)client.builds());
        Assertions.assertNotNull((Object)client.clusterRoleBindings());
        Assertions.assertNotNull((Object)client.deploymentConfigs());
        Assertions.assertNotNull((Object)client.extensions());
        Assertions.assertNotNull((Object)client.groups());
        Assertions.assertNotNull((Object)client.imageStreams());
        Assertions.assertNotNull((Object)client.imageStreamTags());
        Assertions.assertNotNull((Object)client.network());
        Assertions.assertNotNull((Object)client.oAuthAccessTokens());
        Assertions.assertNotNull((Object)client.oAuthAuthorizeTokens());
        Assertions.assertNotNull((Object)client.oAuthClients());
        Assertions.assertNotNull((Object)client.projectrequests());
        Assertions.assertNotNull((Object)client.projects());
        Assertions.assertNotNull((Object)client.pods());
        Assertions.assertNotNull((Object)client.rbac());
        Assertions.assertNotNull((Object)client.roleBindings());
        Assertions.assertNotNull((Object)client.storage());
        Assertions.assertNotNull((Object)client.templates());
        Assertions.assertNotNull((Object)client.users());
    }

    @Test
    void testNamespacePreservation() {
        NamespacedKubernetesClient client = (NamespacedKubernetesClient)new KubernetesClientBuilder().build().adapt(NamespacedKubernetesClient.class);
        OpenShiftClient client1 = (OpenShiftClient)client.inNamespace("x").adapt(OpenShiftClient.class);
        Assertions.assertEquals((Object)"x", (Object)client1.getNamespace());
    }
}

