/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal.build;

import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.impl.BaseClient;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.fabric8.openshift.client.dsl.internal.build.BuildConfigOperationsImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class BuildConfigOperationsImplTest {
    private BaseClient client;
    private HttpClient httpClient;

    BuildConfigOperationsImplTest() {
    }

    @BeforeEach
    public void setUp() {
        this.httpClient = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HttpRequest response = (HttpRequest)Mockito.mock(HttpRequest.class, (Answer)Mockito.CALLS_REAL_METHODS);
        Mockito.when((Object)response.method()).thenReturn((Object)"POST");
        Mockito.when((Object)response.uri()).thenReturn((Object)URI.create("https://localhost:8443/"));
        Mockito.when((Object)this.httpClient.newBuilder().build()).thenReturn((Object)this.httpClient);
        Mockito.when((Object)this.httpClient.newHttpRequestBuilder().post((String)ArgumentMatchers.any(), (InputStream)ArgumentMatchers.any(), ArgumentMatchers.anyLong()).header((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any()).timeout(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any())).uri((String)ArgumentMatchers.any(String.class)).build()).thenReturn((Object)response);
        this.client = (BaseClient)Mockito.mock(BaseClient.class, (Answer)Mockito.RETURNS_SELF);
        Mockito.when((Object)this.client.getKubernetesSerialization()).thenReturn((Object)new KubernetesSerialization());
        Mockito.when((Object)this.client.getHttpClient()).thenReturn((Object)this.httpClient);
        Mockito.when((Object)this.client.getConfiguration()).thenReturn((Object)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl("https://localhost:8443/")).build());
    }

    @Test
    void requestTimeoutDefaultsToZero() {
        Assertions.assertThat((long)new BuildConfigOperationsImpl((Client)this.client).getOperationContext().getTimeout()).isZero();
    }

    @Test
    void withTimeoutOverridesRequestTimeout() {
        BuildConfigOperationsImpl buildConfigOperations = new BuildConfigOperationsImpl((Client)this.client).withTimeout(1337L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((long)buildConfigOperations.getOperationContext().getTimeout()).isEqualTo(1337L);
    }

    @Test
    void withTimeoutInMillisOverridesRequestTimeout() {
        BuildConfigOperationsImpl buildConfigOperations = new BuildConfigOperationsImpl((Client)this.client).withTimeoutInMillis(1337L);
        Assertions.assertThat((long)buildConfigOperations.getOperationContext().getTimeout()).isEqualTo(1337L);
    }

    @Test
    void testWriteToThrowsExceptionShouldAddEvents() {
        final String eventMessage = "FailedScheduling demo-1-7zkjd.1619493da51f6b6f some error";
        BuildConfigOperationsImpl impl = new BuildConfigOperationsImpl((Client)this.client){

            protected String getRecentEvents() {
                return eventMessage;
            }
        };
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new IOException());
        Mockito.when((Object)this.httpClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(byte[].class))).thenReturn(future);
        KubernetesClientException exception = (KubernetesClientException)org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, () -> impl.submitToApiServer((InputStream)inputStream, 0L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)exception.getMessage().contains(eventMessage));
    }

    @Test
    void testWriteShouldCompleteSuccessfully() {
        BuildConfigOperationsImpl impl = new BuildConfigOperationsImpl((Client)this.client){

            protected String getRecentEvents() {
                throw new AssertionError();
            }
        };
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class, (Answer)Mockito.CALLS_REAL_METHODS);
        Mockito.when((Object)response.code()).thenReturn((Object)200);
        Mockito.when((Object)response.body()).thenReturn((Object)new byte[0]);
        Mockito.when((Object)this.httpClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(byte[].class))).thenReturn(CompletableFuture.completedFuture(response));
        impl.submitToApiServer((InputStream)new ByteArrayInputStream(new byte[0]), 0L);
        ((HttpResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).body();
    }
}

