/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal.build;

import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.TestAsyncBody;
import io.fabric8.kubernetes.client.http.TestHttpResponse;
import io.fabric8.kubernetes.client.http.TestStandardHttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientFactory;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.AbstractDurationAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class BuildConfigOperationsTimeoutTest {
    private TestStandardHttpClientFactory factory;
    private OpenShiftClient client;

    BuildConfigOperationsTimeoutTest() {
    }

    @BeforeEach
    void setUp() {
        this.factory = new TestStandardHttpClientFactory();
        this.client = (OpenShiftClient)new KubernetesClientBuilder().withHttpClientFactory((HttpClient.Factory)this.factory).build().adapt(OpenShiftClient.class);
    }

    @DisplayName(value="instantiateBinary has no timeout")
    @Test
    void buildConfigHasZeroTimeout() {
        this.factory.getInstance(1).expect("/apis/build.openshift.io/v1/namespaces/.+/buildconfigs/foo/instantiatebinary", (r, c) -> {
            TestAsyncBody body = new TestAsyncBody();
            c.consume(Collections.singletonList(ByteBuffer.wrap("{\"metadata\": {},\"items\":[]}".getBytes(StandardCharsets.UTF_8))), (AsyncBody)body);
            return CompletableFuture.completedFuture(new TestHttpResponse().withCode(200).withBody((Object)body));
        });
        ((BuildConfigResource)((NonNamespaceOperation)this.client.buildConfigs().inNamespace("default")).withName("foo")).instantiateBinary().fromInputStream((InputStream)new ByteArrayInputStream("bar".getBytes(StandardCharsets.UTF_8)));
        ((AbstractDurationAssert)((ObjectAssert)((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Collection)this.factory.getInstances()).element(1)).extracting(TestStandardHttpClient::getRecordedConsumeBytesDirects).asList().hasSize(1)).singleElement()).extracting("request").extracting("timeout").asInstanceOf(InstanceOfAssertFactories.DURATION)).hasSeconds(0L);
    }
}

