/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.impl;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class OpenShiftConfigTest {
    private Config kubernetesConfig;
    private String version;

    OpenShiftConfigTest() {
    }

    @BeforeEach
    void setup() {
        this.kubernetesConfig = ((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://2.2.2.2")).build();
        this.version = "v1";
        System.setProperty("kubernetes.oapi.version", this.version);
    }

    @AfterEach
    void tearDown() {
        System.clearProperty("openshift.url");
        System.clearProperty("kubernetes.oapi.version");
    }

    @Test
    void testOpenshiftURLAsRoot() {
        System.setProperty("openshift.url", "https://1.1.1.1");
        OpenShiftConfig config = new OpenShiftConfig(this.kubernetesConfig);
        Assertions.assertEquals((Object)("https://1.1.1.1/oapi/" + this.version + "/"), (Object)config.getOpenShiftUrl());
    }

    @Test
    void testOpenshiftURLAsRootWithSlash() {
        System.setProperty("openshift.url", "https://1.1.1.1/");
        OpenShiftConfig config = new OpenShiftConfig(this.kubernetesConfig);
        Assertions.assertEquals((Object)("https://1.1.1.1/oapi/" + this.version + "/"), (Object)config.getOpenShiftUrl());
    }

    @Test
    void testFullOpenshiftURL() {
        System.setProperty("openshift.url", "https://1.1.1.1/xxx");
        OpenShiftConfig config = new OpenShiftConfig(this.kubernetesConfig);
        Assertions.assertEquals((Object)"https://1.1.1.1/xxx/", (Object)config.getOpenShiftUrl());
    }

    @Test
    void testNoOpenshiftURL() {
        System.clearProperty("openshift.url");
        OpenShiftConfig config = new OpenShiftConfig(this.kubernetesConfig);
        Assertions.assertEquals((Object)("https://2.2.2.2/oapi/" + this.version + "/"), (Object)config.getOpenShiftUrl());
    }

    @Test
    void shouldInstantiateClientUsingSerializeDeserialize() {
        OpenShiftClient original = (OpenShiftClient)new KubernetesClientBuilder().build().adapt(OpenShiftClient.class);
        String json = Serialization.asJson((Object)original.getConfiguration());
        KubernetesClient copy = new KubernetesClientBuilder().withConfig(json).build();
        Assertions.assertEquals((Object)original.getConfiguration().getMasterUrl(), (Object)copy.getConfiguration().getMasterUrl());
        Assertions.assertEquals((Object)original.getConfiguration().getOauthToken(), (Object)copy.getConfiguration().getOauthToken());
        Assertions.assertEquals((Object)original.getConfiguration().getNamespace(), (Object)copy.getConfiguration().getNamespace());
        Assertions.assertEquals((Object)original.getConfiguration().getUsername(), (Object)copy.getConfiguration().getUsername());
        Assertions.assertEquals((Object)original.getConfiguration().getPassword(), (Object)copy.getConfiguration().getPassword());
    }
}

