/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.internal;

import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.ContextBuilder;
import io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder;
import io.fabric8.kubernetes.api.model.NamedContextBuilder;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.TestHttpResponse;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import io.fabric8.openshift.client.internal.OpenShiftOAuthInterceptor;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class OpenShiftOAuthInterceptorTest {
    OpenShiftOAuthInterceptorTest() {
    }

    @Test
    void testBasicAuthNotUsed() {
        io.fabric8.kubernetes.client.Config config = io.fabric8.kubernetes.client.Config.empty();
        config.setUsername("user");
        config.setPassword("pass");
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class);
        OpenShiftOAuthInterceptor interceptor = new OpenShiftOAuthInterceptor(client, config);
        StandardHttpRequest.Builder builder = new StandardHttpRequest.Builder();
        builder.uri("http://localhost");
        interceptor.before((BasicBuilder)builder, (HttpRequest)builder.build(), null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.build().headers("Authorization").isEmpty());
    }

    @Test
    void testTokenUsed() {
        io.fabric8.kubernetes.client.Config config = io.fabric8.kubernetes.client.Config.empty();
        config.setUsername("user");
        config.setPassword("pass");
        config.setAutoOAuthToken("token");
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class);
        OpenShiftOAuthInterceptor interceptor = new OpenShiftOAuthInterceptor(client, config);
        StandardHttpRequest.Builder builder = new StandardHttpRequest.Builder();
        builder.uri("http://localhost");
        interceptor.before((BasicBuilder)builder, (HttpRequest)builder.build(), null);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList("Bearer token"), (Object)builder.build().headers("Authorization"));
    }

    @Test
    void testTokenRefreshedFromConfig() {
        io.fabric8.kubernetes.client.Config config = this.mockConfigRefresh();
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class);
        OpenShiftOAuthInterceptor interceptor = new OpenShiftOAuthInterceptor(client, config);
        StandardHttpRequest.Builder builder = new StandardHttpRequest.Builder();
        builder.uri("http://localhost");
        interceptor.afterFailure((HttpRequest.Builder)builder, TestHttpResponse.from((int)401, (String)"not for you").withRequest((HttpRequest)new StandardHttpRequest(null, URI.create("http://localhost"), "GET", null)), null);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList("Bearer token"), (Object)builder.build().headers("Authorization"));
        ((io.fabric8.kubernetes.client.Config)Mockito.verify((Object)config)).setAutoOAuthToken("token");
    }

    @Test
    void afterFailure_whenTokenSetByUser_thenNoRefresh() {
        io.fabric8.kubernetes.client.Config config = (io.fabric8.kubernetes.client.Config)Mockito.mock(io.fabric8.kubernetes.client.Config.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)config.getAutoOAuthToken()).thenReturn(null);
        Mockito.when((Object)config.getOauthToken()).thenReturn((Object)"token-set-by-user");
        Mockito.when((Object)config.refresh()).thenReturn((Object)config);
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class);
        HttpRequest.Builder builder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Answers.RETURNS_SELF);
        OpenShiftOAuthInterceptor interceptor = new OpenShiftOAuthInterceptor(client, config);
        CompletableFuture result = interceptor.afterFailure(builder, TestHttpResponse.from((int)401, (String)"not for you").withRequest((HttpRequest)new StandardHttpRequest(null, URI.create("http://localhost"), "GET", null)), null);
        Assertions.assertThat((CompletableFuture)result).isCompletedWithValue((Object)false);
    }

    @Test
    void afterFailure_whenOAuthTokenProviderPresent_thenUseTokenFromProvider() {
        io.fabric8.kubernetes.client.Config config = (io.fabric8.kubernetes.client.Config)Mockito.mock(io.fabric8.kubernetes.client.Config.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)config.getOauthTokenProvider()).thenReturn(() -> "token-from-oauthtokenprovider");
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class);
        HttpRequest.Builder builder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Answers.RETURNS_SELF);
        builder.uri("http://localhost");
        OpenShiftOAuthInterceptor interceptor = new OpenShiftOAuthInterceptor(client, config);
        CompletableFuture result = interceptor.afterFailure(builder, TestHttpResponse.from((int)401, (String)"not for you").withRequest((HttpRequest)new StandardHttpRequest(null, URI.create("http://localhost"), "GET", null)), null);
        Assertions.assertThat((CompletableFuture)result).isCompletedWithValue((Object)true);
        ((HttpRequest.Builder)Mockito.verify((Object)builder)).setHeader("Authorization", "Bearer token-from-oauthtokenprovider");
    }

    @Test
    void afterFailure_withUsernamePassword_thenShouldAuthorize() {
        try (MockedStatic kubeConfigUtilsMockedStatic = Mockito.mockStatic(KubeConfigUtils.class);){
            io.fabric8.kubernetes.client.Config config = (io.fabric8.kubernetes.client.Config)Mockito.mock(io.fabric8.kubernetes.client.Config.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            Mockito.when((Object)config.getOauthTokenProvider()).thenReturn(null);
            Config kubeConfigContent = (Config)Mockito.mock(Config.class);
            HttpClient client = (HttpClient)Mockito.mock(HttpClient.class);
            HttpRequest.Builder builder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class, (Answer)Answers.RETURNS_SELF);
            HttpRequest httpRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
            HttpClient.DerivedClientBuilder derivedClientBuilder = (HttpClient.DerivedClientBuilder)Mockito.mock(HttpClient.DerivedClientBuilder.class);
            HttpResponse authEndpointHttpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
            HttpResponse authResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
            CompletableFuture<HttpResponse> authEndpointResponseCompletableFuture = new CompletableFuture<HttpResponse>();
            CompletableFuture<HttpResponse> authResponseCompletableFuture = new CompletableFuture<HttpResponse>();
            authEndpointResponseCompletableFuture.complete(authEndpointHttpResponse);
            authResponseCompletableFuture.complete(authResponse);
            Mockito.when((Object)config.getUsername()).thenReturn((Object)"user");
            Mockito.when((Object)config.getPassword()).thenReturn((Object)"pass");
            Mockito.when((Object)config.getMasterUrl()).thenReturn((Object)"http://localhost:8443");
            Mockito.when((Object)config.getCurrentContext()).thenReturn((Object)((NamedContextBuilder)new NamedContextBuilder().withContext(((ContextBuilder)new ContextBuilder().withUser("testuser")).build())).build());
            Mockito.when((Object)config.getFile()).thenReturn((Object)new File("kube/config"));
            Mockito.when((Object)kubeConfigContent.getUsers()).thenReturn(Collections.singletonList(((NamedAuthInfoBuilder)new NamedAuthInfoBuilder().withName("testuser")).build()));
            Mockito.when((Object)client.newBuilder()).thenReturn((Object)derivedClientBuilder);
            Mockito.when((Object)client.newHttpRequestBuilder()).thenReturn((Object)builder);
            Mockito.when((Object)builder.url((URL)ArgumentMatchers.any())).thenReturn((Object)builder);
            Mockito.when((Object)builder.build()).thenReturn((Object)httpRequest);
            Mockito.when((Object)derivedClientBuilder.build()).thenReturn((Object)client);
            Mockito.when((Object)authEndpointHttpResponse.isSuccessful()).thenReturn((Object)true);
            Mockito.when((Object)authEndpointHttpResponse.code()).thenReturn((Object)200);
            Mockito.when((Object)authEndpointHttpResponse.body()).thenReturn((Object)"{\"authorization_endpoint\":\"https://oauth-test/oauth/authorize\"}");
            Mockito.when((Object)authResponse.previousResponse()).thenReturn(Optional.empty());
            Mockito.when((Object)authResponse.headers("Location")).thenReturn(Collections.singletonList("https://oauth-test/oauth/token/implicit#access_token=sha256~secret&expires_in=86400&scope=user%3Afull&token_type=Bearer"));
            Mockito.when((Object)client.sendAsync((HttpRequest)ArgumentMatchers.any(), (Class)ArgumentMatchers.any())).thenReturn(authEndpointResponseCompletableFuture).thenReturn(authResponseCompletableFuture);
            kubeConfigUtilsMockedStatic.when(() -> KubeConfigUtils.parseConfig((File)((File)ArgumentMatchers.any()))).thenReturn((Object)kubeConfigContent);
            OpenShiftOAuthInterceptor interceptor = new OpenShiftOAuthInterceptor(client, config);
            CompletableFuture result = interceptor.afterFailure(builder, TestHttpResponse.from((int)401, (String)"not for you").withRequest((HttpRequest)new StandardHttpRequest(null, URI.create("http://localhost"), "GET", null)), null);
            Assertions.assertThat((CompletableFuture)result).isCompletedWithValue((Object)true);
            kubeConfigUtilsMockedStatic.verify(() -> KubeConfigUtils.persistKubeConfigIntoFile((Config)((Config)ArgumentMatchers.any()), (String)ArgumentMatchers.anyString()));
        }
    }

    @Test
    void testTokenRefreshedFromConfigForWebSocketBuilder() {
        io.fabric8.kubernetes.client.Config config = this.mockConfigRefresh();
        Mockito.when((Object)config.refresh().getAutoOAuthToken()).thenReturn((Object)"token");
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class);
        OpenShiftOAuthInterceptor interceptor = new OpenShiftOAuthInterceptor(client, config);
        WebSocket.Builder builder = (WebSocket.Builder)Mockito.mock(WebSocket.Builder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        interceptor.afterFailure((BasicBuilder)builder, TestHttpResponse.from((int)401, (String)"not for you").withRequest((HttpRequest)new StandardHttpRequest(null, URI.create("http://localhost"), "GET", null)), null);
        ((WebSocket.Builder)Mockito.verify((Object)builder)).setHeader("Authorization", "Bearer token");
        ((io.fabric8.kubernetes.client.Config)Mockito.verify((Object)config)).setAutoOAuthToken("token");
    }

    @Test
    void afterFailure_whenResponseCode403_thenShouldNotRefresh() {
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class);
        io.fabric8.kubernetes.client.Config config = this.mockConfigRefresh();
        HttpResponse<?> httpResponse = this.mockHttpResponse(403);
        HttpRequest.Builder httpRequestBuilder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class);
        OpenShiftOAuthInterceptor interceptor = new OpenShiftOAuthInterceptor(client, config);
        CompletableFuture result = interceptor.afterFailure(httpRequestBuilder, httpResponse, null);
        Assertions.assertThat((CompletableFuture)result).isCompletedWithValue((Object)false);
    }

    @Test
    void afterFailure_whenResponseCode401_thenShouldRefresh() {
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class);
        io.fabric8.kubernetes.client.Config config = this.mockConfigRefresh();
        HttpRequest.Builder httpRequestBuilder = (HttpRequest.Builder)Mockito.mock(HttpRequest.Builder.class);
        HttpResponse<?> httpResponse = this.mockHttpResponse(401);
        OpenShiftOAuthInterceptor interceptor = new OpenShiftOAuthInterceptor(client, config);
        CompletableFuture result = interceptor.afterFailure(httpRequestBuilder, httpResponse, null);
        Assertions.assertThat((CompletableFuture)result).isCompletedWithValue((Object)true);
    }

    private io.fabric8.kubernetes.client.Config mockConfigRefresh() {
        io.fabric8.kubernetes.client.Config config = (io.fabric8.kubernetes.client.Config)Mockito.mock(io.fabric8.kubernetes.client.Config.class);
        io.fabric8.kubernetes.client.Config refreshedConfig = (io.fabric8.kubernetes.client.Config)Mockito.mock(io.fabric8.kubernetes.client.Config.class);
        Mockito.when((Object)refreshedConfig.getAutoOAuthToken()).thenReturn((Object)"token");
        Mockito.when((Object)config.refresh()).thenReturn((Object)refreshedConfig);
        return config;
    }

    private HttpResponse<?> mockHttpResponse(int responseCode) {
        HttpRequest httpRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)httpRequest.method()).thenReturn((Object)"GET");
        Mockito.when((Object)httpRequest.uri()).thenReturn((Object)URI.create("http://www.example.com/apis/routes.openshift.io/namespaces/foo/routes"));
        Mockito.when((Object)httpResponse.request()).thenReturn((Object)httpRequest);
        Mockito.when((Object)httpResponse.code()).thenReturn((Object)responseCode);
        return httpResponse;
    }
}

