/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.mock;

import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.mock.MockKubernetesListOperation;
import io.fabric8.kubernetes.client.mock.MockLoggableResource;
import io.fabric8.kubernetes.client.mock.MockNonNamespaceOperation;
import io.fabric8.kubernetes.client.mock.MockOperation;
import io.fabric8.kubernetes.client.mock.MockResource;
import io.fabric8.kubernetes.client.mock.MockRollableScaleableResource;
import io.fabric8.kubernetes.client.mock.Replayable;
import io.fabric8.kubernetes.client.mock.Verifiable;
import io.fabric8.kubernetes.client.mock.impl.MockEndpoints;
import io.fabric8.kubernetes.client.mock.impl.MockEvent;
import io.fabric8.kubernetes.client.mock.impl.MockKubernetesListOperationImpl;
import io.fabric8.kubernetes.client.mock.impl.MockNamespace;
import io.fabric8.kubernetes.client.mock.impl.MockNode;
import io.fabric8.kubernetes.client.mock.impl.MockPersistentVolume;
import io.fabric8.kubernetes.client.mock.impl.MockPersistentVolumeClaim;
import io.fabric8.kubernetes.client.mock.impl.MockPod;
import io.fabric8.kubernetes.client.mock.impl.MockReplicationController;
import io.fabric8.kubernetes.client.mock.impl.MockResourceQuota;
import io.fabric8.kubernetes.client.mock.impl.MockSecret;
import io.fabric8.kubernetes.client.mock.impl.MockSecurityContextConstraints;
import io.fabric8.kubernetes.client.mock.impl.MockService;
import io.fabric8.kubernetes.client.mock.impl.MockServiceAccount;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableEndpoints;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableEvent;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableNamespace;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableNode;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneablePersistentVolume;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneablePod;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableReplicationController;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableResourceQuota;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableSecret;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableSecurityContextConstraints;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableService;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableServiceAccount;
import io.fabric8.kubernetes.client.mock.util.MockUtils;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.GroupList;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.Policy;
import io.fabric8.openshift.api.model.PolicyBinding;
import io.fabric8.openshift.api.model.PolicyBindingList;
import io.fabric8.openshift.api.model.PolicyList;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingList;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.mock.MockBuildConfigResource;
import io.fabric8.openshift.client.mock.MockProcessableResource;
import io.fabric8.openshift.client.mock.impl.MockBuild;
import io.fabric8.openshift.client.mock.impl.MockBuildConfig;
import io.fabric8.openshift.client.mock.impl.MockDeploymentConfig;
import io.fabric8.openshift.client.mock.impl.MockGroup;
import io.fabric8.openshift.client.mock.impl.MockImageStream;
import io.fabric8.openshift.client.mock.impl.MockOAuthAccessToken;
import io.fabric8.openshift.client.mock.impl.MockOAuthAuthorizeToken;
import io.fabric8.openshift.client.mock.impl.MockOAuthClient;
import io.fabric8.openshift.client.mock.impl.MockPolicy;
import io.fabric8.openshift.client.mock.impl.MockPolicyBinding;
import io.fabric8.openshift.client.mock.impl.MockProject;
import io.fabric8.openshift.client.mock.impl.MockRoleBinding;
import io.fabric8.openshift.client.mock.impl.MockRoute;
import io.fabric8.openshift.client.mock.impl.MockSubjectAccessReview;
import io.fabric8.openshift.client.mock.impl.MockTemplate;
import io.fabric8.openshift.client.mock.impl.MockUser;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneableBuild;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneableBuildConfig;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneableDeploymentConfig;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneableGroup;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneableImageStream;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneableOAuthAccessToken;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneableOAuthAuthorizeToken;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneableOAuthClient;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneablePolicy;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneablePolicyBinding;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneableProject;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneableRoleBinding;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneableRoute;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneableTemplate;
import io.fabric8.openshift.client.mock.impl.doneables.MockDoneableUser;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.easymock.IArgumentMatcher;
import org.easymock.IExpectationSetters;

public class OpenShiftMockClient
implements Replayable<OpenShiftClient>,
Verifiable {
    private final OpenShiftClient client = (OpenShiftClient)EasyMock.createMock(OpenShiftClient.class);
    private OpenShiftMockClient anyNamespaceOp;
    private Map<IArgumentMatcher, OpenShiftMockClient> namespaceMap = new HashMap<IArgumentMatcher, OpenShiftMockClient>();
    private final MockEndpoints endpoints = new MockEndpoints();
    private final MockEvent events = new MockEvent();
    private final MockNode nodes = new MockNode();
    private final MockNamespace namespaces = new MockNamespace();
    private final MockPersistentVolume persistentVolumes = new MockPersistentVolume();
    private final MockPersistentVolumeClaim persistentVolumeClaims = new MockPersistentVolumeClaim();
    private final MockPod pods = new MockPod();
    private final MockService services = new MockService();
    private final MockReplicationController replicationControllers = new MockReplicationController();
    private final MockResourceQuota resourceQuotas = new MockResourceQuota();
    private final MockSecret secrets = new MockSecret();
    private final MockServiceAccount serviceAccounts = new MockServiceAccount();
    private final MockSecurityContextConstraints securityContextConstraints = new MockSecurityContextConstraints();
    private final MockKubernetesListOperationImpl kubernetesLists = new MockKubernetesListOperationImpl();
    private final MockTemplate templates = new MockTemplate();
    private final MockBuild builds = new MockBuild();
    private final MockBuildConfig buildConfigs = new MockBuildConfig();
    private final MockDeploymentConfig deploymentConfigs = new MockDeploymentConfig();
    private final MockImageStream imageStreams = new MockImageStream();
    private final MockOAuthAccessToken oAuthAccessTokens = new MockOAuthAccessToken();
    private final MockOAuthAuthorizeToken oAuthAuthorizeTokens = new MockOAuthAuthorizeToken();
    private final MockOAuthClient oAuthClients = new MockOAuthClient();
    private final MockProject projects = new MockProject();
    private final MockRoute routes = new MockRoute();
    private final MockUser users = new MockUser();
    private final MockGroup groups = new MockGroup();
    private final MockPolicy policies = new MockPolicy();
    private final MockPolicyBinding policyBindings = new MockPolicyBinding();
    private final MockRoleBinding roleBindings = new MockRoleBinding();
    private final MockSubjectAccessReview subjectAccessReviews = new MockSubjectAccessReview();

    public OpenShiftMockClient() {
        EasyMock.expect((Object)this.client.adapt(OpenShiftClient.class)).andReturn((Object)this.client).anyTimes();
        EasyMock.expect((Object)this.client.endpoints()).andReturn((Object)this.endpoints.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.events()).andReturn((Object)this.events.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.nodes()).andReturn((Object)this.nodes.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.namespaces()).andReturn((Object)this.namespaces.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.persistentVolumes()).andReturn((Object)this.persistentVolumes.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.persistentVolumeClaims()).andReturn((Object)this.persistentVolumeClaims.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.pods()).andReturn((Object)this.pods.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.services()).andReturn((Object)this.services.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.replicationControllers()).andReturn((Object)this.replicationControllers.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.resourceQuotas()).andReturn((Object)this.resourceQuotas.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.secrets()).andReturn((Object)this.secrets.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.serviceAccounts()).andReturn((Object)this.serviceAccounts.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.securityContextConstraints()).andReturn((Object)this.securityContextConstraints.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.lists()).andReturn((Object)this.kubernetesLists.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.builds()).andReturn((Object)this.builds.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.buildConfigs()).andReturn((Object)this.buildConfigs.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.deploymentConfigs()).andReturn((Object)this.deploymentConfigs.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.imageStreams()).andReturn((Object)this.imageStreams.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.oAuthAccessTokens()).andReturn((Object)this.oAuthAccessTokens.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.oAuthAuthorizeTokens()).andReturn((Object)this.oAuthAuthorizeTokens.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.oAuthClients()).andReturn((Object)this.oAuthClients.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.projects()).andReturn((Object)this.projects.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.routes()).andReturn((Object)this.routes.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.templates()).andReturn((Object)this.templates.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.users()).andReturn((Object)this.users.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.groups()).andReturn((Object)this.groups.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.policies()).andReturn((Object)this.policies.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.policyBindings()).andReturn((Object)this.policyBindings.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.roleBindings()).andReturn((Object)this.roleBindings.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.subjectAccessReviews()).andReturn((Object)this.subjectAccessReviews.getDelegate()).anyTimes();
        this.client.close();
        EasyMock.expectLastCall().anyTimes();
    }

    public OpenShiftClient replay() {
        this.endpoints.replay();
        this.events.replay();
        this.nodes.replay();
        this.namespaces.replay();
        this.persistentVolumes.replay();
        this.persistentVolumeClaims.replay();
        this.pods.replay();
        this.services.replay();
        this.replicationControllers.replay();
        this.resourceQuotas.replay();
        this.secrets.replay();
        this.serviceAccounts.replay();
        this.securityContextConstraints.replay();
        this.kubernetesLists.replay();
        this.builds.replay();
        this.buildConfigs.replay();
        this.deploymentConfigs.replay();
        this.imageStreams.replay();
        this.oAuthAccessTokens.replay();
        this.oAuthAuthorizeTokens.replay();
        this.oAuthClients.replay();
        this.projects.replay();
        this.routes.replay();
        this.templates.replay();
        this.users.replay();
        this.groups.replay();
        this.policies.replay();
        this.policyBindings.replay();
        this.roleBindings.replay();
        this.subjectAccessReviews.replay();
        EasyMock.replay((Object[])new Object[]{this.client});
        return this.client;
    }

    public void verify() {
        this.endpoints.verify();
        this.events.verify();
        this.nodes.verify();
        this.namespaces.verify();
        this.persistentVolumes.verify();
        this.persistentVolumeClaims.verify();
        this.pods.verify();
        this.services.verify();
        this.replicationControllers.verify();
        this.resourceQuotas.verify();
        this.secrets.verify();
        this.serviceAccounts.verify();
        this.securityContextConstraints.verify();
        this.kubernetesLists.verify();
        this.builds.verify();
        this.buildConfigs.verify();
        this.deploymentConfigs.verify();
        this.imageStreams.verify();
        this.oAuthAccessTokens.verify();
        this.oAuthAuthorizeTokens.verify();
        this.oAuthClients.verify();
        this.projects.verify();
        this.routes.verify();
        this.templates.verify();
        this.users.verify();
        this.groups.verify();
        this.policies.verify();
        this.policyBindings.verify();
        this.roleBindings.verify();
        this.subjectAccessReviews.verify();
        EasyMock.verify((Object[])new Object[]{this.client});
    }

    public IExpectationSetters<URL> getMasterUrl() {
        return EasyMock.expect((Object)this.client.getMasterUrl());
    }

    public IExpectationSetters<Config> getConfiguration() {
        return EasyMock.expect((Object)this.client.getConfiguration());
    }

    public IExpectationSetters<RootPaths> rootPaths() {
        return EasyMock.expect((Object)this.client.rootPaths());
    }

    public MockOperation<Endpoints, EndpointsList, MockDoneableEndpoints, MockResource<Endpoints, MockDoneableEndpoints, Boolean>> endpoints() {
        return this.endpoints;
    }

    public MockOperation<Event, EventList, MockDoneableEvent, MockResource<Event, MockDoneableEvent, Boolean>> events() {
        return this.events;
    }

    public MockNonNamespaceOperation<Namespace, NamespaceList, MockDoneableNamespace, MockResource<Namespace, MockDoneableNamespace, Boolean>> namespaces() {
        return this.namespaces;
    }

    public MockNonNamespaceOperation<Node, NodeList, MockDoneableNode, MockResource<Node, MockDoneableNode, Boolean>> nodes() {
        return this.nodes;
    }

    public MockOperation<PersistentVolume, PersistentVolumeList, MockDoneablePersistentVolume, MockResource<PersistentVolume, MockDoneablePersistentVolume, Boolean>> persistentVolumes() {
        return this.persistentVolumes;
    }

    public MockOperation<PersistentVolumeClaim, PersistentVolumeClaimList, MockDoneablePersistentVolumeClaim, MockResource<PersistentVolumeClaim, MockDoneablePersistentVolumeClaim, Boolean>> persistentVolumeClaims() {
        return this.persistentVolumeClaims;
    }

    public MockOperation<Pod, PodList, MockDoneablePod, MockLoggableResource<Pod, MockDoneablePod, Boolean>> pods() {
        return this.pods;
    }

    public MockOperation<ReplicationController, ReplicationControllerList, MockDoneableReplicationController, MockRollableScaleableResource<ReplicationController, MockDoneableReplicationController, Boolean>> replicationControllers() {
        return this.replicationControllers;
    }

    public MockOperation<ResourceQuota, ResourceQuotaList, MockDoneableResourceQuota, MockResource<ResourceQuota, MockDoneableResourceQuota, Boolean>> resourceQuotas() {
        return this.resourceQuotas;
    }

    public MockOperation<Secret, SecretList, MockDoneableSecret, MockResource<Secret, MockDoneableSecret, Boolean>> secrets() {
        return this.secrets;
    }

    public MockOperation<Service, ServiceList, MockDoneableService, MockResource<Service, MockDoneableService, Boolean>> services() {
        return this.services;
    }

    public MockOperation<ServiceAccount, ServiceAccountList, MockDoneableServiceAccount, MockResource<ServiceAccount, MockDoneableServiceAccount, Boolean>> serviceAccounts() {
        return this.serviceAccounts;
    }

    public MockOperation<SecurityContextConstraints, SecurityContextConstraintsList, MockDoneableSecurityContextConstraints, MockResource<SecurityContextConstraints, MockDoneableSecurityContextConstraints, Boolean>> securityContextConstraints() {
        return this.securityContextConstraints;
    }

    public MockKubernetesListOperation lists() {
        return this.kubernetesLists;
    }

    public MockOperation<Build, BuildList, MockDoneableBuild, MockResource<Build, MockDoneableBuild, Boolean>> builds() {
        return this.builds;
    }

    public MockOperation<BuildConfig, BuildConfigList, MockDoneableBuildConfig, MockBuildConfigResource> buildConfigs() {
        return this.buildConfigs;
    }

    public MockOperation<DeploymentConfig, DeploymentConfigList, MockDoneableDeploymentConfig, MockResource<DeploymentConfig, MockDoneableDeploymentConfig, Boolean>> deploymentConfigs() {
        return this.deploymentConfigs;
    }

    public MockOperation<ImageStream, ImageStreamList, MockDoneableImageStream, MockResource<ImageStream, MockDoneableImageStream, Boolean>> imageStreams() {
        return this.imageStreams;
    }

    public MockNonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, MockDoneableOAuthAccessToken, MockResource<OAuthAccessToken, MockDoneableOAuthAccessToken, Boolean>> oAuthAccessTokens() {
        return this.oAuthAccessTokens;
    }

    public MockNonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, MockDoneableOAuthAuthorizeToken, MockResource<OAuthAuthorizeToken, MockDoneableOAuthAuthorizeToken, Boolean>> oAuthAuthorizeTokens() {
        return this.oAuthAuthorizeTokens;
    }

    public MockNonNamespaceOperation<OAuthClient, OAuthClientList, MockDoneableOAuthClient, MockResource<OAuthClient, MockDoneableOAuthClient, Boolean>> oAuthClients() {
        return this.oAuthClients;
    }

    public MockNonNamespaceOperation<Project, ProjectList, MockDoneableProject, MockResource<Project, MockDoneableProject, Boolean>> projects() {
        return this.projects;
    }

    public MockOperation<Route, RouteList, MockDoneableRoute, MockResource<Route, MockDoneableRoute, Boolean>> routes() {
        return this.routes;
    }

    public MockOperation<Template, TemplateList, MockDoneableTemplate, MockProcessableResource<Template, MockDoneableTemplate, Boolean>> templates() {
        return this.templates;
    }

    public MockOperation<Group, GroupList, MockDoneableGroup, MockResource<Group, MockDoneableGroup, Boolean>> groups() {
        return this.groups;
    }

    public MockOperation<User, UserList, MockDoneableUser, MockResource<User, MockDoneableUser, Boolean>> users() {
        return this.users;
    }

    public MockOperation<Policy, PolicyList, MockDoneablePolicy, MockResource<Policy, MockDoneablePolicy, Boolean>> policies() {
        return this.policies;
    }

    public MockOperation<PolicyBinding, PolicyBindingList, MockDoneablePolicyBinding, MockResource<PolicyBinding, MockDoneablePolicyBinding, Boolean>> policyBindings() {
        return this.policyBindings;
    }

    public MockOperation<RoleBinding, RoleBindingList, MockDoneableRoleBinding, MockResource<RoleBinding, MockDoneableRoleBinding, Boolean>> roleBindings() {
        return this.roleBindings;
    }

    public MockSubjectAccessReview getSubjectAccessReviews() {
        return this.subjectAccessReviews;
    }

    public OpenShiftMockClient inNamespace(String namespace) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)namespace);
        OpenShiftMockClient op = this.namespaceMap.get(matcher);
        if (op == null) {
            OpenShiftMockClient namespacedClient;
            op = namespacedClient = new OpenShiftMockClient();
            EasyMock.expect((Object)this.client.inNamespace(namespace)).andAnswer((IAnswer)new IAnswer<OpenShiftClient>(){

                public OpenShiftClient answer() throws Throwable {
                    return namespacedClient.replay();
                }
            }).anyTimes();
            this.namespaceMap.put(matcher, op);
        }
        return op;
    }

    public OpenShiftMockClient inAnyNamepace() {
        if (this.anyNamespaceOp == null) {
            OpenShiftMockClient namespacedClient;
            this.anyNamespaceOp = namespacedClient = new OpenShiftMockClient();
            EasyMock.expect((Object)this.client.inAnyNamespace()).andAnswer((IAnswer)new IAnswer<OpenShiftClient>(){

                public OpenShiftClient answer() throws Throwable {
                    return namespacedClient.replay();
                }
            }).anyTimes();
        }
        return this.anyNamespaceOp;
    }

    public <T extends Client> IExpectationSetters<T> adapt(Class<T> type) {
        return EasyMock.expect((Object)this.client.adapt(type));
    }
}

