/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client;

import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.WithRequestCallable;
import io.fabric8.kubernetes.client.dsl.FunctionCallable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.servicecatalog.api.model.ClusterServiceBroker;
import io.fabric8.servicecatalog.api.model.ClusterServiceBrokerList;
import io.fabric8.servicecatalog.api.model.ClusterServiceClass;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassList;
import io.fabric8.servicecatalog.api.model.ClusterServicePlan;
import io.fabric8.servicecatalog.api.model.ClusterServicePlanList;
import io.fabric8.servicecatalog.api.model.DoneableClusterServiceBroker;
import io.fabric8.servicecatalog.api.model.DoneableClusterServiceClass;
import io.fabric8.servicecatalog.api.model.DoneableClusterServicePlan;
import io.fabric8.servicecatalog.api.model.DoneableServiceBinding;
import io.fabric8.servicecatalog.api.model.DoneableServiceBroker;
import io.fabric8.servicecatalog.api.model.DoneableServiceClass;
import io.fabric8.servicecatalog.api.model.DoneableServiceInstance;
import io.fabric8.servicecatalog.api.model.DoneableServicePlan;
import io.fabric8.servicecatalog.api.model.ServiceBinding;
import io.fabric8.servicecatalog.api.model.ServiceBindingList;
import io.fabric8.servicecatalog.api.model.ServiceBroker;
import io.fabric8.servicecatalog.api.model.ServiceBrokerList;
import io.fabric8.servicecatalog.api.model.ServiceClass;
import io.fabric8.servicecatalog.api.model.ServiceClassList;
import io.fabric8.servicecatalog.api.model.ServiceInstance;
import io.fabric8.servicecatalog.api.model.ServiceInstanceList;
import io.fabric8.servicecatalog.api.model.ServicePlan;
import io.fabric8.servicecatalog.api.model.ServicePlanList;
import io.fabric8.servicecatalog.client.NamespacedServiceCatalogClient;
import io.fabric8.servicecatalog.client.internal.ClusterServiceBrokerOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ClusterServiceBrokerResource;
import io.fabric8.servicecatalog.client.internal.ClusterServiceClassOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ClusterServiceClassResource;
import io.fabric8.servicecatalog.client.internal.ClusterServicePlanOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ClusterServicePlanResource;
import io.fabric8.servicecatalog.client.internal.ServiceBindingOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ServiceBindingResource;
import io.fabric8.servicecatalog.client.internal.ServiceBrokerOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ServiceClassOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ServiceInstanceOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ServiceInstanceResource;
import io.fabric8.servicecatalog.client.internal.ServicePlanOperationsImpl;
import okhttp3.OkHttpClient;

public class DefaultServiceCatalogClient
extends BaseClient
implements NamespacedServiceCatalogClient {
    public DefaultServiceCatalogClient() {
    }

    public DefaultServiceCatalogClient(Config configuration) {
        super(configuration);
    }

    public DefaultServiceCatalogClient(OkHttpClient httpClient, Config configuration) {
        super(httpClient, configuration);
    }

    @Override
    public NonNamespaceOperation<ClusterServiceBroker, ClusterServiceBrokerList, DoneableClusterServiceBroker, ClusterServiceBrokerResource> clusterServiceBrokers() {
        return new ClusterServiceBrokerOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<ClusterServiceClass, ClusterServiceClassList, DoneableClusterServiceClass, ClusterServiceClassResource> clusterServiceClasses() {
        return new ClusterServiceClassOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<ClusterServicePlan, ClusterServicePlanList, DoneableClusterServicePlan, ClusterServicePlanResource> clusterServicePlans() {
        return new ClusterServicePlanOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    @Override
    public MixedOperation<ServiceInstance, ServiceInstanceList, DoneableServiceInstance, ServiceInstanceResource> serviceInstances() {
        return new ServiceInstanceOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    @Override
    public MixedOperation<ServiceBinding, ServiceBindingList, DoneableServiceBinding, ServiceBindingResource> serviceBindings() {
        return new ServiceBindingOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    @Override
    public MixedOperation<ServiceBroker, ServiceBrokerList, DoneableServiceBroker, Resource<ServiceBroker, DoneableServiceBroker>> serviceBrokers() {
        return new ServiceBrokerOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    @Override
    public MixedOperation<ServiceClass, ServiceClassList, DoneableServiceClass, Resource<ServiceClass, DoneableServiceClass>> serviceClasses() {
        return new ServiceClassOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    @Override
    public MixedOperation<ServicePlan, ServicePlanList, DoneableServicePlan, Resource<ServicePlan, DoneableServicePlan>> servicePlans() {
        return new ServicePlanOperationsImpl(this.getHttpClient(), this.getConfiguration());
    }

    public NamespacedServiceCatalogClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    public NamespacedServiceCatalogClient inNamespace(String namespace) {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new DefaultServiceCatalogClient(this.getHttpClient(), updated);
    }

    public FunctionCallable<NamespacedServiceCatalogClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable((Client)this, requestConfig);
    }
}

