/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.servicecatalog.api.model.ClusterServiceClass;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassList;
import io.fabric8.servicecatalog.api.model.ClusterServicePlan;
import io.fabric8.servicecatalog.api.model.ClusterServicePlanList;
import io.fabric8.servicecatalog.api.model.DoneableClusterServiceClass;
import io.fabric8.servicecatalog.api.model.DoneableServiceInstance;
import io.fabric8.servicecatalog.api.model.ServiceInstance;
import io.fabric8.servicecatalog.api.model.ServiceInstanceFluent;
import io.fabric8.servicecatalog.client.internal.ClusterServiceClassResource;
import io.fabric8.servicecatalog.client.internal.ClusterServicePlanOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ClusterServicePlanResource;
import io.fabric8.servicecatalog.client.internal.ServiceInstanceOperationsImpl;
import java.util.HashMap;
import java.util.List;
import okhttp3.OkHttpClient;

public class ClusterServiceClassOperationsImpl
extends HasMetadataOperation<ClusterServiceClass, ClusterServiceClassList, DoneableClusterServiceClass, ClusterServiceClassResource>
implements ClusterServiceClassResource {
    public ClusterServiceClassOperationsImpl(OkHttpClient client, Config config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public ClusterServiceClassOperationsImpl(OperationContext ctx) {
        super(ctx.withApiGroupName("servicecatalog.k8s.io").withApiGroupVersion("v1beta1").withPlural("clusterserviceclasses"));
        this.type = ClusterServiceClass.class;
        this.listType = ClusterServiceClassList.class;
        this.doneableType = DoneableClusterServiceClass.class;
    }

    public BaseOperation<ClusterServiceClass, ClusterServiceClassList, DoneableClusterServiceClass, ClusterServiceClassResource> newInstance(OperationContext context) {
        return new ClusterServiceClassOperationsImpl(context);
    }

    public boolean isResourceNamespaced() {
        return false;
    }

    @Override
    public ClusterServicePlanList listPlans() {
        ClusterServiceClass item = (ClusterServiceClass)this.get();
        return (ClusterServicePlanList)new ClusterServicePlanOperationsImpl(this.context).withField("spec.clusterServiceClassRef.name", item != null ? item.getMetadata().getName() : null).list();
    }

    @Override
    public ClusterServicePlanResource usePlan(String externalName) {
        ClusterServiceClass item = (ClusterServiceClass)this.get();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("spec.clusterServiceClassRef.name", item.getMetadata().getName());
        fields.put("spec.externalName", externalName);
        List list = ((ClusterServicePlanList)new ClusterServicePlanOperationsImpl(this.context.withFields(fields)).list()).getItems();
        if (list.size() != 1) {
            throw new IllegalArgumentException("No unique ClusterServicePlan with external name: " + externalName + " found for ClusterServiceBroker: " + item.getSpec().getClusterServiceBrokerName() + " and ClusterServiceClass: " + item.getSpec().getExternalName() + ".");
        }
        ClusterServicePlan p = (ClusterServicePlan)list.get(0);
        return new ClusterServicePlanOperationsImpl(this.context);
    }

    @Override
    public ServiceInstance instantiate(String instanceName, String plan) {
        ClusterServiceClass item = (ClusterServiceClass)this.get();
        return ((DoneableServiceInstance)((ServiceInstanceFluent.SpecNested)((ServiceInstanceFluent.SpecNested)((DoneableServiceInstance)((ServiceInstanceFluent.MetadataNested)((DoneableServiceInstance)new ServiceInstanceOperationsImpl(this.context).createNew()).withNewMetadata().withName(instanceName)).endMetadata()).withNewSpec().withClusterServiceClassExternalName(item.getMetadata().getName())).withClusterServicePlanExternalName(plan)).endSpec()).done();
    }
}

