/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.SecretOperationsImpl;
import io.fabric8.servicecatalog.api.model.ServiceBinding;
import io.fabric8.servicecatalog.api.model.ServiceBindingBuilder;
import io.fabric8.servicecatalog.api.model.ServiceBindingList;
import io.fabric8.servicecatalog.client.internal.ServiceBindingResource;
import okhttp3.OkHttpClient;

public class ServiceBindingOperationsImpl
extends HasMetadataOperation<ServiceBinding, ServiceBindingList, ServiceBindingResource>
implements ServiceBindingResource {
    public ServiceBindingOperationsImpl(OkHttpClient client, Config config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public ServiceBindingOperationsImpl(OperationContext ctx) {
        super(ctx.withApiGroupName("servicecatalog.k8s.io").withApiGroupVersion("v1beta1").withPlural("servicebindings"));
        this.type = ServiceBinding.class;
        this.listType = ServiceBindingList.class;
    }

    public BaseOperation<ServiceBinding, ServiceBindingList, ServiceBindingResource> newInstance(OperationContext context) {
        return new ServiceBindingOperationsImpl(context);
    }

    public boolean isResourceNamespaced() {
        return true;
    }

    public ServiceBinding edit(Visitor ... visitors) {
        return (ServiceBinding)this.patch((HasMetadata)((ServiceBindingBuilder)new ServiceBindingBuilder((ServiceBinding)this.getMandatory()).accept(visitors)).build());
    }

    @Override
    public Secret getSecret() {
        ServiceBinding instance = (ServiceBinding)this.get();
        return (Secret)new SecretOperationsImpl(this.context.withItem(null).withName(instance.getSpec().getSecretName())).get();
    }
}

