package io.fabric8.tekton.pipeline.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ArrayOrStringFluent<A extends ArrayOrStringFluent<A>> extends BaseFluent<A>{
  public ArrayOrStringFluent() {
  }
  
  public ArrayOrStringFluent(ArrayOrString instance) {
    this.copyInstance(instance);
  }
  private List<String> arrayVal;
  private String stringVal;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ArrayOrString instance) {
    instance = (instance != null ? instance : new ArrayOrString());
    if (instance != null) {
          this.withArrayVal(instance.getArrayVal());
          this.withStringVal(instance.getStringVal());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToArrayVal(int index,String item) {
    if (this.arrayVal == null) {this.arrayVal = new ArrayList<String>();}
    this.arrayVal.add(index, item);
    return (A)this;
  }
  
  public A setToArrayVal(int index,String item) {
    if (this.arrayVal == null) {this.arrayVal = new ArrayList<String>();}
    this.arrayVal.set(index, item); return (A)this;
  }
  
  public A addToArrayVal(java.lang.String... items) {
    if (this.arrayVal == null) {this.arrayVal = new ArrayList<String>();}
    for (String item : items) {this.arrayVal.add(item);} return (A)this;
  }
  
  public A addAllToArrayVal(Collection<String> items) {
    if (this.arrayVal == null) {this.arrayVal = new ArrayList<String>();}
    for (String item : items) {this.arrayVal.add(item);} return (A)this;
  }
  
  public A removeFromArrayVal(java.lang.String... items) {
    if (this.arrayVal == null) return (A)this;
    for (String item : items) { this.arrayVal.remove(item);} return (A)this;
  }
  
  public A removeAllFromArrayVal(Collection<String> items) {
    if (this.arrayVal == null) return (A)this;
    for (String item : items) { this.arrayVal.remove(item);} return (A)this;
  }
  
  public List<String> getArrayVal() {
    return this.arrayVal;
  }
  
  public String getArrayVal(int index) {
    return this.arrayVal.get(index);
  }
  
  public String getFirstArrayVal() {
    return this.arrayVal.get(0);
  }
  
  public String getLastArrayVal() {
    return this.arrayVal.get(arrayVal.size() - 1);
  }
  
  public String getMatchingArrayVal(Predicate<String> predicate) {
      for (String item : arrayVal) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingArrayVal(Predicate<String> predicate) {
      for (String item : arrayVal) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withArrayVal(List<String> arrayVal) {
    if (arrayVal != null) {
        this.arrayVal = new ArrayList();
        for (String item : arrayVal) {
          this.addToArrayVal(item);
        }
    } else {
      this.arrayVal = null;
    }
    return (A) this;
  }
  
  public A withArrayVal(java.lang.String... arrayVal) {
    if (this.arrayVal != null) {
        this.arrayVal.clear();
        _visitables.remove("arrayVal");
    }
    if (arrayVal != null) {
      for (String item : arrayVal) {
        this.addToArrayVal(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasArrayVal() {
    return this.arrayVal != null && !this.arrayVal.isEmpty();
  }
  
  public String getStringVal() {
    return this.stringVal;
  }
  
  public A withStringVal(String stringVal) {
    this.stringVal = stringVal;
    return (A) this;
  }
  
  public boolean hasStringVal() {
    return this.stringVal != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ArrayOrStringFluent that = (ArrayOrStringFluent) o;
    if (!java.util.Objects.equals(arrayVal, that.arrayVal)) return false;
    if (!java.util.Objects.equals(stringVal, that.stringVal)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(arrayVal,  stringVal,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (arrayVal != null && !arrayVal.isEmpty()) { sb.append("arrayVal:"); sb.append(arrayVal + ","); }
    if (stringVal != null) { sb.append("stringVal:"); sb.append(stringVal + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}