package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourcePatternBuilder extends ResourcePatternFluent<ResourcePatternBuilder> implements VisitableBuilder<ResourcePattern,ResourcePatternBuilder>{
  public ResourcePatternBuilder() {
    this(new ResourcePattern());
  }
  
  public ResourcePatternBuilder(ResourcePatternFluent<?> fluent) {
    this(fluent, new ResourcePattern());
  }
  
  public ResourcePatternBuilder(ResourcePatternFluent<?> fluent,ResourcePattern instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourcePatternBuilder(ResourcePattern instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourcePatternFluent<?> fluent;
  
  public ResourcePattern build() {
    ResourcePattern buildable = new ResourcePattern(fluent.getPattern());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}