/*
 * Decompiled with CFR 0.152.
 */
package org.boon.slumberdb.mysql;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Logger;
import org.boon.primitive.CharBuf;
import org.boon.slumberdb.KeyValueIterable;
import org.boon.slumberdb.config.GlobalConfig;
import org.boon.slumberdb.entries.Entry;

public abstract class BaseMySQLSupport<T> {
    protected final String sqlColumnType;
    private final boolean debug = GlobalConfig.DEBUG;
    protected String url;
    protected String userName;
    protected String password;
    protected String table;
    protected Connection connection;
    protected String insertStatementSQL;
    protected String selectStatementSQL;
    protected String searchStatementSQL;
    protected String createStatementSQL;
    protected String deleteStatementSQL;
    protected String tableExistsSQL;
    protected PreparedStatement insert;
    protected PreparedStatement delete;
    protected PreparedStatement select;
    protected PreparedStatement search;
    protected PreparedStatement loadAll;
    protected PreparedStatement allKeys;
    protected Logger logger = Boon.configurableLogger(BaseMySQLSupport.class);
    protected String loadAllSQL;
    protected int batchSize = 100;
    protected String selectKeysSQL;
    protected int loadKeyCount = 100;
    protected PreparedStatement loadAllKeys;
    protected String loadAllKeysSQL;
    private long totalConnectionOpen;
    private long totalClosedConnections;
    private long totalErrors;
    private boolean closed;

    public BaseMySQLSupport(String password, String userName, String url, String table, String sqlColumnType, int batchSize) {
        this.sqlColumnType = sqlColumnType;
        this.password = password;
        this.userName = userName;
        this.url = url;
        this.table = table;
        this.batchSize = batchSize;
        this.loadKeyCount = batchSize;
        this.createSQL(table);
        this.initDB();
    }

    public long totalConnectionOpen() {
        return this.totalConnectionOpen;
    }

    public long totalClosedConnections() {
        return this.totalClosedConnections;
    }

    public long totalErrors() {
        return this.totalErrors;
    }

    protected void initDB() {
        this.connect();
        this.createTableIfNeeded();
        this.createPreparedStatements();
    }

    protected abstract T getValueColumn(int var1, ResultSet var2) throws SQLException;

    protected abstract void setValueColumnQueryParam(int var1, PreparedStatement var2, T var3) throws SQLException;

    protected void createSQL(String table) {
        this.insertStatementSQL = "replace into `" + table + "` (kv_key, kv_value) values (?,?);";
        this.selectStatementSQL = "select kv_value from `" + table + "` where kv_key = ?;";
        this.searchStatementSQL = "select kv_key, kv_value from `" + table + "` where kv_key >= ?;";
        this.loadAllSQL = "select kv_key, kv_value from `" + table + "`;";
        this.selectKeysSQL = "select kv_key from `" + table + "`;";
        this.createLoadAllKeysSQL(table);
        this.deleteStatementSQL = "delete  from `" + table + "` where kv_key = ?;";
        this.tableExistsSQL = "select * from `" + table + "` where 1!=1;";
        this.createTableSQL(table);
        if (this.debug) {
            this.logger.info(new Object[]{"The following SQL statements will be used", "insert", this.insertStatementSQL, "select", this.selectStatementSQL, "search", this.searchStatementSQL, "LOAD", this.loadAllSQL, "SELECT_KEYS", this.selectKeysSQL, "DELETE", this.deleteStatementSQL, "TABLE EXISTS", this.tableExistsSQL, "CREATE_TABLE", this.createStatementSQL});
        }
    }

    protected void createTableSQL(String table) {
        this.createStatementSQL = "\nCREATE TABLE `" + table + "` (\n" + "  `id` bigint(20) NOT NULL AUTO_INCREMENT,\n" + "  `kv_key` varchar(80) DEFAULT NULL,\n" + "  `kv_value` " + this.sqlColumnType + ",\n" + "  PRIMARY KEY (`id`),\n" + "  UNIQUE KEY  `" + table + "_kv_key_idx` (`kv_key`)\n" + ");\n";
    }

    protected void createLoadAllKeysSQL(String table) {
        CharBuf buf = CharBuf.create((int)100);
        buf.add("select kv_key, kv_value from `");
        buf.add(table);
        buf.add("` where kv_key in (");
        buf.multiply((CharSequence)"?,", this.loadKeyCount);
        buf.removeLastChar();
        buf.add(");");
        this.loadAllKeysSQL = buf.toString();
    }

    protected void connect() {
        try {
            MysqlDataSource dataSource = new MysqlDataSource();
            dataSource.setURL(this.url);
            dataSource.setPassword(this.password);
            dataSource.setUser(this.userName);
            this.connection = dataSource.getConnection();
            this.connection.setAutoCommit(true);
            this.closed = false;
            ++this.totalConnectionOpen;
        }
        catch (SQLException sqlException) {
            this.closed = true;
            this.connection = null;
            this.handle("Unable to connect", sqlException);
        }
    }

    protected void createTableIfNeeded() {
        if (this.closed) {
            return;
        }
        try {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery(this.tableExistsSQL);
            resultSet.next();
        }
        catch (SQLException e) {
            this.closed = true;
            this.close();
            this.connect();
            try {
                Statement statement = this.connection.createStatement();
                statement.execute(this.createStatementSQL);
            }
            catch (SQLException e1) {
                this.handle("Unable to create prepare table " + this.createStatementSQL, e);
            }
        }
    }

    protected void handle(String message, SQLException sqlException) {
        ++this.totalErrors;
        if (this.debug) {
            this.handleSQLException(sqlException);
        }
        try {
            this.close();
        }
        catch (Exception ex) {
            this.logger.warn((Throwable)ex, new Object[]{"Problem closing connection after sql exception\n", sqlException});
        }
        Exceptions.handle((String)message, (Throwable)sqlException);
    }

    public void handleSQLException(SQLException ex) {
        SQLException next = ex.getNextException();
        while (next != null) {
            this.logger.warn((Throwable)next, new Object[]{"BasyMySQLSupport Nested SQL Exception", next.getMessage()});
            next = ex.getNextException();
        }
    }

    protected void createPreparedStatements() {
        if (this.closed) {
            return;
        }
        try {
            this.insert = this.connection.prepareStatement(this.insertStatementSQL);
            this.delete = this.connection.prepareStatement(this.deleteStatementSQL);
            this.select = this.connection.prepareStatement(this.selectStatementSQL);
            this.search = this.connection.prepareStatement(this.searchStatementSQL);
            this.loadAll = this.connection.prepareStatement(this.loadAllSQL);
            this.allKeys = this.connection.prepareStatement(this.selectKeysSQL);
            this.loadAllKeys = this.connection.prepareStatement(this.loadAllKeysSQL);
        }
        catch (SQLException e) {
            this.handle("Unable to create prepared statements", e);
        }
    }

    public void removeAll(Iterable<String> keys) {
        this.initIfNeeded();
        this.removeAllUseBatch(keys);
    }

    protected void removeAllUseBatch(Iterable<String> keys) {
        this.initIfNeeded();
        try {
            for (String key : keys) {
                this.delete.setString(1, key);
                this.delete.addBatch();
            }
            this.delete.executeBatch();
        }
        catch (SQLException e) {
            this.handle("Unable to removeAll values", e);
        }
    }

    public void remove(String key) {
        this.initIfNeeded();
        if (this.debug) {
            this.logger.info(new Object[]{"REMOVE KEY", key});
        }
        try {
            this.delete.setString(1, key);
            this.delete.executeUpdate();
        }
        catch (SQLException e) {
            this.delete = null;
            this.closed = true;
            this.connection = null;
            this.handle(Boon.sputs((Object[])new Object[]{"Unable to remove key", key}), e);
        }
    }

    public KeyValueIterable<String, T> search(final String startKey) {
        this.initIfNeeded();
        if (this.debug) {
            this.logger.info(new Object[]{"SEARCH", startKey});
        }
        try {
            this.search.setString(1, startKey);
            final ResultSet resultSet = this.search.executeQuery();
            return new KeyValueIterable<String, T>(){

                public void close() {
                    BaseMySQLSupport.this.closeResultSet(resultSet);
                }

                public Iterator<Entry<String, T>> iterator() {
                    return new Iterator<Entry<String, T>>(){

                        @Override
                        public boolean hasNext() {
                            return BaseMySQLSupport.this.resultSetNext(resultSet);
                        }

                        @Override
                        public Entry<String, T> next() {
                            try {
                                String key = resultSet.getString(1);
                                Object value = BaseMySQLSupport.this.getValueColumn(2, resultSet);
                                return new Entry((Object)key, value);
                            }
                            catch (SQLException e) {
                                BaseMySQLSupport.this.handle("Unable to extract values for search query for " + startKey, e);
                                return null;
                            }
                        }

                        @Override
                        public void remove() {
                        }
                    };
                }
            };
        }
        catch (SQLException e) {
            this.handle(Boon.sputs((Object[])new Object[]{"Unable to search records search key", startKey, "\nquery=", this.searchStatementSQL}), e);
            return null;
        }
    }

    protected boolean resultSetNext(ResultSet resultSet) {
        try {
            return resultSet.next();
        }
        catch (SQLException e) {
            this.closeResultSet(resultSet);
            this.handle("Unable to call next() for result set", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.logger.warn((Object)"Problem closing", (Throwable)e);
        }
        finally {
            this.closed = true;
            this.connection = null;
            ++this.totalClosedConnections;
        }
    }

    protected void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"Unable to close result set", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> loadAllKeys() {
        this.initIfNeeded();
        if (this.debug) {
            this.logger.info((Object)"LOAD ALL KEYS");
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        ResultSet resultSet = null;
        try {
            resultSet = this.allKeys.executeQuery();
            while (resultSet.next()) {
                String key = resultSet.getString(1);
                set.add(key);
            }
        }
        catch (SQLException e) {
            this.handle("Unable to call next() for result set for loadAllByKeysPreparedStatement query", e);
        }
        finally {
            this.closeResultSet(resultSet);
        }
        if (this.debug) {
            this.logger.debug(new Object[]{"LOAD ALL KEYS BEGETS", set});
        }
        return set;
    }

    public T load(String key) {
        T value;
        this.initIfNeeded();
        if (this.debug) {
            this.logger.info(new Object[]{"LOAD KEY", key});
        }
        try {
            this.select.setString(1, key);
            ResultSet resultSet = this.select.executeQuery();
            value = resultSet.next() ? (T)this.getValueColumn(1, resultSet) : null;
        }
        catch (SQLException ex) {
            this.handle("Unable to load " + key, ex);
            return null;
        }
        return value;
    }

    protected void keyBatch(Map<String, T> results, List<String> keyLoadList) {
        while (keyLoadList.size() < this.loadKeyCount) {
            keyLoadList.add(null);
        }
        try {
            int indexToLoad = 1;
            for (String keyToLoad : keyLoadList) {
                this.loadAllKeys.setString(indexToLoad, keyToLoad);
                ++indexToLoad;
            }
            ResultSet resultSet = this.loadAllKeys.executeQuery();
            while (resultSet.next()) {
                String keyResult = resultSet.getString(1);
                T valueResult = this.getValueColumn(2, resultSet);
                results.put(keyResult, valueResult);
            }
            resultSet.close();
        }
        catch (SQLException ex) {
            this.handle("Unable to load " + keyLoadList, ex);
        }
    }

    public void put(String key, T value) {
        this.initIfNeeded();
        if (this.debug) {
            this.logger.info(new Object[]{"PUT KEY", key, value});
        }
        try {
            this.insert.setString(1, key);
            this.setValueColumnQueryParam(2, this.insert, value);
            this.insert.executeUpdate();
        }
        catch (SQLException e) {
            this.handle(Boon.sputs((Object[])new Object[]{"Unable to insert key", key, "value", value}), e);
        }
    }

    public void putAllUseBatch(Map<String, T> values) {
        block8: {
            this.initIfNeeded();
            int count = 0;
            try {
                Set<Map.Entry<String, T>> entries = values.entrySet();
                for (Map.Entry<String, T> entry : entries) {
                    String key = entry.getKey();
                    T value = entry.getValue();
                    this.insert.setString(1, key);
                    this.setValueColumnQueryParam(2, this.insert, value);
                    this.insert.addBatch();
                    if (count == this.batchSize) {
                        count = 0;
                        this.insert.executeBatch();
                        continue;
                    }
                    ++count;
                }
                this.insert.executeBatch();
            }
            catch (SQLException e) {
                boolean recover = true;
                if (e instanceof SQLTransactionRollbackException) {
                    for (Map.Entry<String, T> entry : values.entrySet()) {
                        try {
                            this.put(entry.getKey(), entry.getValue());
                        }
                        catch (Exception ex) {
                            this.logger.warn((Throwable)ex, new Object[]{"BaseMySQLSUpport", "Unable to save", entry.getKey()});
                            recover = false;
                        }
                    }
                }
                if (recover) break block8;
                this.handle("BaseMySQLSUpport Unable to putALl values " + values.size(), e);
            }
        }
    }

    private void initIfNeeded() {
        if (this.closed) {
            this.logger.warn((Object)"closed detected, reopening connection");
            this.initDB();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAllUseTransaction(Map<String, T> values) {
        this.initIfNeeded();
        try {
            this.connection.setAutoCommit(false);
            Set<Map.Entry<String, T>> entries = values.entrySet();
            for (Map.Entry<String, T> entry : entries) {
                String key = entry.getKey();
                T value = entry.getValue();
                this.insert.setString(1, key);
                this.setValueColumnQueryParam(2, this.insert, value);
                this.insert.executeUpdate();
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                this.logger.warn((Object)"Unable to rollback exception", (Throwable)e1);
            }
            this.handle("Unable to putALl values", e);
        }
        finally {
            try {
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.logger.warn((Object)"Unable to set auto commit back to true", (Throwable)e);
            }
        }
    }

    public void putAll(Map<String, T> values) {
        this.initIfNeeded();
        if (this.debug) {
            this.logger.info(new Object[]{"PUT ALL ", values});
        }
        this.putAllUseBatch(values);
    }

    public Map<String, T> loadAllByKeys(Collection<String> keys) {
        if (this.debug) {
            this.logger.info(new Object[]{"LOAD ALL BY KEYS ", keys});
        }
        this.initIfNeeded();
        LinkedHashMap results = new LinkedHashMap(keys.size());
        ArrayList<String> keyLoadList = new ArrayList<String>(this.loadKeyCount);
        for (String key : keys) {
            keyLoadList.add(key);
            if (keyLoadList.size() != this.loadKeyCount) continue;
            this.keyBatch(results, keyLoadList);
            keyLoadList.clear();
        }
        this.keyBatch(results, keyLoadList);
        return results;
    }

    public KeyValueIterable<String, T> loadAll() {
        if (this.debug) {
            this.logger.info((Object)"LOAD ALL  ");
        }
        this.initIfNeeded();
        try {
            final ResultSet resultSet = this.loadAll.executeQuery();
            return new KeyValueIterable<String, T>(){

                public void close() {
                    BaseMySQLSupport.this.closeResultSet(resultSet);
                }

                public Iterator<Entry<String, T>> iterator() {
                    return new Iterator<Entry<String, T>>(){

                        @Override
                        public boolean hasNext() {
                            return BaseMySQLSupport.this.resultSetNext(resultSet);
                        }

                        @Override
                        public Entry<String, T> next() {
                            try {
                                String key = resultSet.getString(1);
                                Object value = BaseMySQLSupport.this.getValueColumn(2, resultSet);
                                return new Entry((Object)key, value);
                            }
                            catch (SQLException e) {
                                BaseMySQLSupport.this.handle("Unable to extract values for loadAllByKeys query", e);
                                return null;
                            }
                        }

                        @Override
                        public void remove() {
                        }
                    };
                }
            };
        }
        catch (SQLException e) {
            this.handle("Unable to load all records", e);
            return null;
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

