/*
 * Decompiled with CFR 0.152.
 */
package org.boon.slumberdb.mysql;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.Logger;
import org.boon.collections.LazyMap;
import org.boon.core.Conversions;
import org.boon.primitive.CharBuf;
import org.boon.slumberdb.KeyValueIterable;
import org.boon.slumberdb.config.GlobalConfig;
import org.boon.slumberdb.entries.Entry;
import org.boon.slumberdb.entries.VersionKey;
import org.boon.slumberdb.entries.VersionedEntry;
import org.boon.slumberdb.spi.VersionedStorageProvider;

public class BaseVersionedMySQLSupport
implements VersionedStorageProvider {
    protected final String sqlColumnType = "LONGBLOB";
    private final boolean debug = GlobalConfig.DEBUG;
    protected String url;
    protected String userName;
    protected String password;
    protected String table;
    protected Connection connection;
    protected String insertStatementSQL;
    protected String selectStatementSQL;
    protected String searchStatementSQL;
    protected String createStatementSQL;
    protected String deleteStatementSQL;
    protected String tableExistsSQL;
    protected PreparedStatement insert;
    protected PreparedStatement delete;
    protected PreparedStatement select;
    protected PreparedStatement search;
    protected PreparedStatement loadAll;
    protected PreparedStatement allKeys;
    protected PreparedStatement loadAllVersionDataByKeys;
    protected Logger logger = Boon.configurableLogger(BaseVersionedMySQLSupport.class);
    protected String loadAllSQL;
    protected int batchSize = 100;
    protected String selectKeysSQL;
    protected int loadKeyCount = 100;
    protected PreparedStatement loadAllByKeysPreparedStatement;
    protected String loadAllByKeysSQL;
    protected String loadAllVersionDataByKeysSQL;
    private long totalConnectionOpen;
    private long totalClosedConnections;
    private long totalErrors;
    private boolean closed;
    private int KEY_POS = 1;
    private int VALUE_POS = 2;
    private int VERSION_POS = 3;
    private int UPDATE_POS = 4;
    private int CREATE_POS = 5;

    public BaseVersionedMySQLSupport(String password, String userName, String url, String table, int writeBatchSize, int readBatch) {
        this.password = password;
        this.userName = userName;
        this.url = url;
        this.table = table;
        this.batchSize = writeBatchSize;
        this.loadKeyCount = readBatch;
        this.createSQL(table);
        this.initDB();
    }

    protected void initDB() {
        this.connect();
        this.createTableIfNeeded();
        this.createPreparedStatements();
    }

    protected void createTableSQL(String table) {
        this.createStatementSQL = "\nCREATE TABLE `" + table + "` (\n" + "  `id` bigint(20) NOT NULL AUTO_INCREMENT,\n" + "  `create_timestamp` bigint(20) NOT NULL,\n" + "  `version` bigint(20) NOT NULL,\n" + "  `update_timestamp` bigint(20) NOT NULL,\n" + "  `kv_key` varchar(80) NOT NULL,\n" + "  `kv_value` " + "LONGBLOB" + ",\n" + "  PRIMARY KEY (`id`),\n" + "  UNIQUE KEY  `" + table + "_kv_key_idx` (`kv_key`)\n" + ");\n";
    }

    public void removeAll(Iterable<String> keys) {
        this.initIfNeeded();
        try {
            for (String key : keys) {
                this.delete.setString(1, key);
                this.delete.addBatch();
            }
            this.delete.executeBatch();
        }
        catch (SQLException e) {
            this.handle("Unable to removeAll values", e);
        }
    }

    public void remove(String key) {
        this.initIfNeeded();
        if (this.debug) {
            this.logger.info(new Object[]{"REMOVE KEY", key});
        }
        try {
            this.delete.setString(1, key);
            this.delete.executeUpdate();
        }
        catch (SQLException e) {
            this.delete = null;
            this.closed = true;
            this.connection = null;
            this.handle(Boon.sputs((Object[])new Object[]{"Unable to remove key", key}), e);
        }
    }

    public KeyValueIterable<String, VersionedEntry<String, byte[]>> search(final String startKey) {
        this.initIfNeeded();
        if (this.debug) {
            this.logger.info(new Object[]{"SEARCH", startKey});
        }
        try {
            this.search.setString(1, startKey);
            final ResultSet resultSet = this.search.executeQuery();
            return new KeyValueIterable<String, VersionedEntry<String, byte[]>>(){

                public void close() {
                    BaseVersionedMySQLSupport.this.closeResultSet(resultSet);
                }

                public Iterator<Entry<String, VersionedEntry<String, byte[]>>> iterator() {
                    return new Iterator<Entry<String, VersionedEntry<String, byte[]>>>(){

                        @Override
                        public boolean hasNext() {
                            return BaseVersionedMySQLSupport.this.resultSetNext(resultSet);
                        }

                        @Override
                        public Entry<String, VersionedEntry<String, byte[]>> next() {
                            try {
                                String key = resultSet.getString(1);
                                byte[] value = BaseVersionedMySQLSupport.this.getValueColumn(BaseVersionedMySQLSupport.this.VALUE_POS, resultSet);
                                long version = resultSet.getLong(BaseVersionedMySQLSupport.this.VERSION_POS);
                                long update = resultSet.getLong(BaseVersionedMySQLSupport.this.UPDATE_POS);
                                long create = resultSet.getLong(BaseVersionedMySQLSupport.this.CREATE_POS);
                                VersionedEntry ve = new VersionedEntry((Object)key, (Object)value);
                                ve.setCreateTimestamp(create);
                                ve.setUpdateTimestamp(update);
                                ve.setVersion(version);
                                return new Entry((Object)key, (Object)ve);
                            }
                            catch (SQLException e) {
                                BaseVersionedMySQLSupport.this.handle("Unable to extract values for search query for " + startKey, e);
                                return null;
                            }
                        }

                        @Override
                        public void remove() {
                        }
                    };
                }
            };
        }
        catch (SQLException e) {
            this.handle(Boon.sputs((Object[])new Object[]{"Unable to search records search key", startKey, "\nquery=", this.searchStatementSQL}), e);
            return null;
        }
    }

    protected boolean resultSetNext(ResultSet resultSet) {
        try {
            return resultSet.next();
        }
        catch (SQLException e) {
            this.closeResultSet(resultSet);
            this.handle("Unable to call next() for result set", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> loadAllKeys() {
        this.initIfNeeded();
        if (this.debug) {
            this.logger.info((Object)"LOAD ALL KEYS");
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        ResultSet resultSet = null;
        try {
            resultSet = this.allKeys.executeQuery();
            while (resultSet.next()) {
                String key = resultSet.getString(1);
                set.add(key);
            }
        }
        catch (SQLException e) {
            this.handle("Unable to call next() for result set for loadAllByKeysPreparedStatement query", e);
        }
        finally {
            this.closeResultSet(resultSet);
        }
        if (this.debug) {
            this.logger.debug(new Object[]{"LOAD ALL KEYS BEGETS", set});
        }
        return set;
    }

    public VersionedEntry<String, byte[]> load(String key) {
        this.initIfNeeded();
        VersionedEntry returnValue = null;
        if (this.debug) {
            this.logger.info(new Object[]{"LOAD KEY", key});
        }
        try {
            this.select.setString(1, key);
            ResultSet resultSet = this.select.executeQuery();
            if (resultSet.next()) {
                byte[] value = this.getValueColumn(this.VALUE_POS, resultSet);
                long version = resultSet.getLong(this.VERSION_POS);
                long update = resultSet.getLong(this.UPDATE_POS);
                long create = resultSet.getLong(this.CREATE_POS);
                returnValue = new VersionedEntry((Object)key, (Object)value);
                returnValue.setCreateTimestamp(create);
                returnValue.setUpdateTimestamp(update);
                returnValue.setVersion(version);
            }
        }
        catch (SQLException ex) {
            this.handle("Unable to load " + key, ex);
        }
        return returnValue;
    }

    protected void keyBatch(LazyMap results, List<String> keyLoadList, boolean getValue) {
        while (keyLoadList.size() < this.loadKeyCount) {
            keyLoadList.add(null);
        }
        try {
            int indexToLoad = 1;
            for (String keyToLoad : keyLoadList) {
                this.loadAllByKeysPreparedStatement.setString(indexToLoad, keyToLoad);
                ++indexToLoad;
            }
            ResultSet resultSet = this.loadAllByKeysPreparedStatement.executeQuery();
            while (resultSet.next()) {
                String key = resultSet.getString(this.KEY_POS);
                byte[] value = getValue ? this.getValueColumn(this.VALUE_POS, resultSet) : null;
                long version = resultSet.getLong(this.VERSION_POS);
                long update = resultSet.getLong(this.UPDATE_POS);
                long create = resultSet.getLong(this.CREATE_POS);
                if (getValue) {
                    VersionedEntry returnValue = new VersionedEntry((Object)key, (Object)value);
                    returnValue.setCreateTimestamp(create);
                    returnValue.setUpdateTimestamp(update);
                    returnValue.setVersion(version);
                    results.put(key, (Object)returnValue);
                    continue;
                }
                VersionKey versionKey = new VersionKey(key, version, update, create);
                results.put(key, (Object)versionKey);
            }
            resultSet.close();
        }
        catch (SQLException ex) {
            this.handle("Unable to load " + keyLoadList, ex);
        }
    }

    public void put(String key, VersionedEntry<String, byte[]> entry) {
        this.initIfNeeded();
        if (this.debug) {
            this.logger.info(new Object[]{"PUT KEY", key, entry});
        }
        try {
            this.insert.setString(this.KEY_POS, key);
            this.setValueColumnQueryParam(this.VALUE_POS, this.insert, (byte[])entry.value());
            this.insert.setLong(this.CREATE_POS, entry.createdOn());
            this.insert.setLong(this.UPDATE_POS, entry.updatedOn());
            this.insert.executeUpdate();
        }
        catch (SQLException e) {
            this.handle(Boon.sputs((Object[])new Object[]{"Unable to insert key", key, "value", entry}), e);
        }
    }

    private void initIfNeeded() {
        if (this.closed) {
            this.logger.warn((Object)"closed detected, reopening connection");
            this.initDB();
        }
    }

    public void putAll(Map<String, VersionedEntry<String, byte[]>> values) {
        block9: {
            this.initIfNeeded();
            if (this.debug) {
                this.logger.info(new Object[]{"PUT ALL ", values});
            }
            int count = 0;
            try {
                Set<Map.Entry<String, VersionedEntry<String, byte[]>>> entries = values.entrySet();
                for (Map.Entry<String, VersionedEntry<String, byte[]>> entry : entries) {
                    String key = entry.getKey();
                    this.insert.setString(this.KEY_POS, key);
                    this.setValueColumnQueryParam(this.VALUE_POS, this.insert, (byte[])entry.getValue().value());
                    this.insert.setLong(this.CREATE_POS, entry.getValue().createdOn());
                    this.insert.setLong(this.UPDATE_POS, entry.getValue().updatedOn());
                    this.insert.addBatch();
                    if (count == this.batchSize) {
                        count = 0;
                        this.insert.executeBatch();
                        continue;
                    }
                    ++count;
                }
                this.insert.executeBatch();
            }
            catch (SQLException e) {
                boolean recover = true;
                if (e instanceof SQLTransactionRollbackException) {
                    for (Map.Entry<String, VersionedEntry<String, byte[]>> entry : values.entrySet()) {
                        try {
                            this.put(entry.getKey(), entry.getValue());
                        }
                        catch (Exception ex) {
                            this.logger.warn((Throwable)ex, new Object[]{"BaseMySQLSUpport", "Unable to save", entry.getKey()});
                            recover = false;
                        }
                    }
                }
                if (recover) break block9;
                this.handle("BaseMySQLSUpport Unable to putALl values " + values.size(), e);
            }
        }
    }

    public Map<String, VersionedEntry<String, byte[]>> loadAllByKeys(Collection<String> keys) {
        if (this.debug) {
            this.logger.info(new Object[]{"LOAD ALL BY KEYS ", keys});
        }
        this.initIfNeeded();
        LazyMap results = new LazyMap(keys.size());
        ArrayList<String> keyLoadList = new ArrayList<String>(this.loadKeyCount);
        for (String key : keys) {
            keyLoadList.add(key);
            if (keyLoadList.size() != this.loadKeyCount) continue;
            this.keyBatch(results, keyLoadList, true);
            keyLoadList.clear();
        }
        this.keyBatch(results, keyLoadList, true);
        return (Map)results;
    }

    public List<VersionKey> loadAllVersionInfoByKeys(Collection<String> keys) {
        if (this.debug) {
            this.logger.info(new Object[]{"LOAD ALL BY KEYS ", keys});
        }
        this.initIfNeeded();
        LazyMap results = new LazyMap(keys.size());
        ArrayList<String> keyLoadList = new ArrayList<String>(this.loadKeyCount);
        for (String key : keys) {
            keyLoadList.add(key);
            if (keyLoadList.size() != this.loadKeyCount) continue;
            this.keyBatch(results, keyLoadList, true);
            keyLoadList.clear();
        }
        this.keyBatch(results, keyLoadList, true);
        return Conversions.toList((Object)results.values());
    }

    public KeyValueIterable<String, VersionedEntry<String, byte[]>> loadAll() {
        if (this.debug) {
            this.logger.info((Object)"LOAD ALL  ");
        }
        this.initIfNeeded();
        try {
            final ResultSet resultSet = this.loadAll.executeQuery();
            return new KeyValueIterable<String, VersionedEntry<String, byte[]>>(){

                public void close() {
                    BaseVersionedMySQLSupport.this.closeResultSet(resultSet);
                }

                public Iterator<Entry<String, VersionedEntry<String, byte[]>>> iterator() {
                    return new Iterator<Entry<String, VersionedEntry<String, byte[]>>>(){

                        @Override
                        public boolean hasNext() {
                            return BaseVersionedMySQLSupport.this.resultSetNext(resultSet);
                        }

                        @Override
                        public Entry<String, VersionedEntry<String, byte[]>> next() {
                            try {
                                String key = resultSet.getString(BaseVersionedMySQLSupport.this.KEY_POS);
                                byte[] value = BaseVersionedMySQLSupport.this.getValueColumn(BaseVersionedMySQLSupport.this.VALUE_POS, resultSet);
                                long version = resultSet.getLong(BaseVersionedMySQLSupport.this.VERSION_POS);
                                long update = resultSet.getLong(BaseVersionedMySQLSupport.this.UPDATE_POS);
                                long create = resultSet.getLong(BaseVersionedMySQLSupport.this.CREATE_POS);
                                VersionedEntry returnValue = new VersionedEntry((Object)key, (Object)value);
                                returnValue.setCreateTimestamp(create);
                                returnValue.setUpdateTimestamp(update);
                                returnValue.setVersion(version);
                                return new Entry((Object)key, (Object)returnValue);
                            }
                            catch (SQLException e) {
                                BaseVersionedMySQLSupport.this.handle("Unable to extract values for loadAllByKeys query", e);
                                return null;
                            }
                        }

                        @Override
                        public void remove() {
                        }
                    };
                }
            };
        }
        catch (SQLException e) {
            this.handle("Unable to load all records", e);
            return null;
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public VersionKey loadVersion(String key) {
        List<VersionKey> versionKeys = this.loadAllVersionInfoByKeys(Lists.list((Object[])new String[]{key}));
        if (versionKeys.size() == 1) {
            return versionKeys.get(0);
        }
        return VersionKey.notFound((String)key);
    }

    protected void createTableIfNeeded() {
        if (this.closed) {
            return;
        }
        try {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery(this.tableExistsSQL);
            resultSet.next();
        }
        catch (SQLException e) {
            this.closed = true;
            this.close();
            this.connect();
            try {
                Statement statement = this.connection.createStatement();
                statement.execute(this.createStatementSQL);
            }
            catch (SQLException e1) {
                this.handle("Unable to create prepare table " + this.createStatementSQL, e);
            }
        }
    }

    protected void handle(String message, SQLException sqlException) {
        ++this.totalErrors;
        if (this.debug) {
            this.handleSQLException(sqlException);
        }
        try {
            this.close();
        }
        catch (Exception ex) {
            this.logger.warn((Throwable)ex, new Object[]{"Problem closing connection after sql exception\n", sqlException});
        }
        Exceptions.handle((String)message, (Throwable)sqlException);
    }

    protected void connect() {
        try {
            MysqlDataSource dataSource = new MysqlDataSource();
            dataSource.setURL(this.url);
            dataSource.setPassword(this.password);
            dataSource.setUser(this.userName);
            this.connection = dataSource.getConnection();
            this.connection.setAutoCommit(true);
            this.closed = false;
            ++this.totalConnectionOpen;
        }
        catch (SQLException sqlException) {
            this.closed = true;
            this.connection = null;
            this.handle("Unable to connect", sqlException);
        }
    }

    public void handleSQLException(SQLException ex) {
        SQLException next = ex.getNextException();
        while (next != null) {
            this.logger.warn((Throwable)next, new Object[]{"BasyMySQLSupport Nested SQL Exception", next.getMessage()});
            next = ex.getNextException();
        }
    }

    protected void createPreparedStatements() {
        if (this.closed) {
            return;
        }
        try {
            this.insert = this.connection.prepareStatement(this.insertStatementSQL);
            this.delete = this.connection.prepareStatement(this.deleteStatementSQL);
            this.select = this.connection.prepareStatement(this.selectStatementSQL);
            this.search = this.connection.prepareStatement(this.searchStatementSQL);
            this.loadAll = this.connection.prepareStatement(this.loadAllSQL);
            this.allKeys = this.connection.prepareStatement(this.selectKeysSQL);
            this.loadAllByKeysPreparedStatement = this.connection.prepareStatement(this.loadAllByKeysSQL);
        }
        catch (SQLException e) {
            this.handle("Unable to create prepared statements", e);
        }
    }

    public long totalConnectionOpen() {
        return this.totalConnectionOpen;
    }

    public long totalClosedConnections() {
        return this.totalClosedConnections;
    }

    public long totalErrors() {
        return this.totalErrors;
    }

    protected byte[] getValueColumn(int index, ResultSet resultSet) throws SQLException {
        return resultSet.getBytes(index);
    }

    protected void setValueColumnQueryParam(int index, PreparedStatement p, byte[] value) throws SQLException {
        p.setBytes(index, value);
    }

    protected void createSQL(String table) {
        this.insertStatementSQL = "replace into `" + table + "` (kv_key, kv_value, version, update_timestamp, create_timestamp)" + " values (?,?);";
        this.selectStatementSQL = "select kv_key, kv_value, version, update_timestamp, create_timestamp from `" + table + "` where kv_key = ?;";
        this.searchStatementSQL = "select kv_key, kv_value, version, update_timestamp, create_timestamp from `" + table + "` where kv_key >= ?;";
        this.loadAllSQL = "select kv_key, kv_value, version, update_timestamp, create_timestamp  from `" + table + "`;";
        this.selectKeysSQL = "select kv_key from `" + table + "`;";
        this.createLoadAllKeysSQL(table);
        this.deleteStatementSQL = "delete  from `" + table + "` where kv_key = ?;";
        this.tableExistsSQL = "select * from `" + table + "` where 1!=1;";
        this.createTableSQL(table);
        this.createLoadAllVersionDataSQL(table);
        if (this.debug) {
            this.logger.info(new Object[]{"The following SQL statements will be used", "insert", this.insertStatementSQL, "select", this.selectStatementSQL, "search", this.searchStatementSQL, "LOAD", this.loadAllSQL, "SELECT_KEYS", this.selectKeysSQL, "DELETE", this.deleteStatementSQL, "TABLE EXISTS", this.tableExistsSQL, "CREATE_TABLE", this.createStatementSQL});
        }
    }

    protected void createLoadAllKeysSQL(String table) {
        CharBuf buf = CharBuf.create((int)100);
        buf.add("select kv_key, kv_value, version, update_timestamp, create_timestamp from `");
        buf.add(table);
        buf.add("` where kv_key in (");
        buf.multiply((CharSequence)"?,", this.loadKeyCount);
        buf.removeLastChar();
        buf.add(");");
        this.loadAllByKeysSQL = buf.toString();
    }

    protected void createLoadAllVersionDataSQL(String table) {
        CharBuf buf = CharBuf.create((int)100);
        buf.add("select kv_key, 1, version, update_timestamp, create_timestamp from `");
        buf.add(table);
        buf.add("` where kv_key in (");
        buf.multiply((CharSequence)"?,", this.loadKeyCount);
        buf.removeLastChar();
        buf.add(");");
        this.loadAllVersionDataByKeysSQL = buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.logger.warn((Object)"Problem closing", (Throwable)e);
        }
        finally {
            this.closed = true;
            this.connection = null;
            ++this.totalClosedConnections;
        }
    }

    protected void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"Unable to close result set", (Throwable)e);
            }
        }
    }
}

