package io.featurehub.sse.api;

import cd.connect.openapi.support.ApiClient;
import cd.connect.openapi.support.ApiResponse;
import cd.connect.openapi.support.Pair;

import java.io.InputStream;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.*;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;

import io.featurehub.sse.model.FeatureEnvironmentCollection;
import io.featurehub.sse.model.FeatureStateUpdate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@jakarta.annotation.Generated(value = "cd.connect.openapi.Jersey3ApiGenerator", date = "2022-11-02T21:49:56.106483+13:00[Pacific/Auckland]")




@Path("/features")
public interface FeatureService {

  /**
   * 
   * Requests all features for this sdkurl and disconnects
   * @param sdkUrl A list of API keys to retrieve information about (required)
   
	   * @return List&lt;FeatureEnvironmentCollection&gt;
   
   */
  @GET
    @Path("/")
    @Produces({ "application/json" })
  public List<FeatureEnvironmentCollection> getFeatureStates( @org.jetbrains.annotations.NotNull @jakarta.validation.constraints.NotNull
 @QueryParam("sdkUrl") List<String> sdkUrl
);
  /**
   * 
   * Updates the feature state if allowed.
   * @param sdkUrl The API Key for the environment and service account (required)
   * @param featureKey The key you wish to update/action (required)
   * @param featureStateUpdate  (required)
   
   */
  @PUT
    @Path("/{sdkUrl}/{featureKey}")
    @Consumes({ "application/json" })
  public void setFeatureState( @PathParam("sdkUrl") @org.jetbrains.annotations.NotNull String sdkUrl
,  @PathParam("featureKey") @org.jetbrains.annotations.NotNull String featureKey
, 
@org.jetbrains.annotations.NotNull  @jakarta.validation.constraints.NotNull  @Valid 
FeatureStateUpdate featureStateUpdate);
}
