/*
 * Decompiled with CFR 0.152.
 */
package io.featurehub.edge.sse;

import io.featurehub.client.EdgeService;
import io.featurehub.client.FeatureHubConfig;
import io.featurehub.client.FeatureStore;
import io.featurehub.client.Readyness;
import io.featurehub.client.edge.EdgeConnectionState;
import io.featurehub.client.edge.EdgeReconnector;
import io.featurehub.client.edge.EdgeRetryService;
import io.featurehub.client.utils.SdkVersion;
import io.featurehub.sse.model.SSEResultState;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSEClient
implements EdgeService,
EdgeReconnector {
    private static final Logger log = LoggerFactory.getLogger(SSEClient.class);
    private final FeatureStore repository;
    private final FeatureHubConfig config;
    private EventSource eventSource;
    private EventSource.Factory eventSourceFactory;
    private String xFeaturehubHeader;
    private OkHttpClient client;
    private final EdgeRetryService retryer;
    private boolean connectionSaidBye;
    private final List<CompletableFuture<Readyness>> waitingClients = new ArrayList<CompletableFuture<Readyness>>();

    public SSEClient(FeatureStore repository, FeatureHubConfig config, EdgeRetryService retryer) {
        this.repository = repository;
        this.config = config;
        this.retryer = retryer;
    }

    public void poll() {
        if (this.eventSource == null) {
            this.initEventSource();
        }
    }

    private void initEventSource() {
        Request.Builder reqBuilder = new Request.Builder().url(this.config.getRealtimeUrl());
        if (this.xFeaturehubHeader != null) {
            reqBuilder = reqBuilder.addHeader("x-featurehub", this.xFeaturehubHeader);
        }
        reqBuilder.addHeader("X-SDK", SdkVersion.sdkVersionHeader((String)"Java-OKHTTP-SSE"));
        Request request = reqBuilder.build();
        this.connectionSaidBye = false;
        final SSEClient connector = this;
        this.eventSource = this.makeEventSource(request, new EventSourceListener(){

            public void onClosed(@NotNull EventSource eventSource) {
                log.trace("[featurehub-sdk] closed");
                if (SSEClient.this.repository.getReadyness() == Readyness.NotReady) {
                    SSEClient.this.repository.notify(SSEResultState.FAILURE, null);
                }
                SSEClient.this.retryer.edgeResult(SSEClient.this.connectionSaidBye ? EdgeConnectionState.SERVER_SAID_BYE : EdgeConnectionState.SERVER_WAS_DISCONNECTED, connector);
            }

            public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
                try {
                    SSEResultState state = SSEClient.this.fromValue(type);
                    if (state == null) {
                        return;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("[featurehub-sdk] decode packet {}:{}", (Object)type, (Object)data);
                    }
                    SSEClient.this.repository.notify(state, data);
                    if (state == SSEResultState.FEATURES) {
                        SSEClient.this.retryer.edgeResult(EdgeConnectionState.SUCCESS, connector);
                    }
                    if (state == SSEResultState.BYE) {
                        SSEClient.this.connectionSaidBye = true;
                    }
                    if (state == SSEResultState.FAILURE) {
                        SSEClient.this.retryer.edgeResult(EdgeConnectionState.API_KEY_NOT_FOUND, connector);
                    }
                    if (!SSEClient.this.waitingClients.isEmpty() && state != SSEResultState.ACK) {
                        SSEClient.this.waitingClients.forEach(wc -> wc.complete(SSEClient.this.repository.getReadyness()));
                    }
                }
                catch (Exception e) {
                    log.error("[featurehub-sdk] failed to decode packet {}:{}", new Object[]{type, data, e});
                }
            }

            public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                log.trace("[featurehub-sdk] failed to connect to {} - {}", new Object[]{SSEClient.this.config.baseUrl(), response, t});
                if (SSEClient.this.repository.getReadyness() == Readyness.NotReady) {
                    SSEClient.this.repository.notify(SSEResultState.FAILURE, null);
                }
                SSEClient.this.retryer.edgeResult(EdgeConnectionState.SERVER_WAS_DISCONNECTED, connector);
            }

            public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
                log.trace("[featurehub-sdk] connected to {}", (Object)SSEClient.this.config.baseUrl());
            }
        });
    }

    protected SSEResultState fromValue(String name) {
        try {
            return SSEResultState.fromValue((String)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected EventSource makeEventSource(Request request, EventSourceListener listener) {
        if (this.eventSourceFactory == null) {
            this.client = new OkHttpClient.Builder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
            this.eventSourceFactory = EventSources.createFactory((OkHttpClient)this.client);
        }
        return this.eventSourceFactory.newEventSource(request, listener);
    }

    @NotNull
    public Future<Readyness> contextChange(String newHeader) {
        CompletableFuture<Readyness> change = new CompletableFuture<Readyness>();
        if (this.config.isServerEvaluation() && (newHeader != null && !newHeader.equals(this.xFeaturehubHeader) || this.xFeaturehubHeader != null && !this.xFeaturehubHeader.equals(newHeader))) {
            log.warn("[featurehub-sdk] please only use server evaluated keys with SSE with one repository per SSE client.");
            this.xFeaturehubHeader = newHeader;
            if (this.eventSource != null) {
                this.eventSource.cancel();
                this.eventSource = null;
            }
        }
        if (this.eventSource == null) {
            this.waitingClients.add(change);
            this.poll();
        } else {
            change.complete(this.repository.getReadyness());
        }
        return change;
    }

    public boolean isClientEvaluation() {
        return !this.config.isServerEvaluation();
    }

    public void close() {
        this.retryer.close();
        if (this.client != null) {
            this.client.dispatcher().executorService().shutdownNow();
            this.client.connectionPool().evictAll();
        }
        if (this.eventSource != null) {
            log.info("[featurehub-sdk] closing connection");
            this.eventSource.cancel();
            this.eventSource = null;
        }
        if (this.eventSourceFactory != null) {
            this.eventSourceFactory = null;
        }
    }

    @NotNull
    public FeatureHubConfig getConfig() {
        return this.config;
    }

    public boolean isRequiresReplacementOnHeaderChange() {
        return false;
    }

    public void reconnect() {
        this.initEventSource();
    }
}

