/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.repository;

import io.fixprotocol.orchestra.event.EventListener;
import io.fixprotocol.orchestra.repository.RepositoryValidatorImpl;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class RepositoryValidator {
    private final String inputFile;
    private final String eventFile;

    public static Builder builder() {
        return new Builder();
    }

    public static void main(String[] args) throws Exception {
        Builder builder = RepositoryValidator.builder();
        for (int i = 0; i < args.length; ++i) {
            if ("-e".equals(args[i])) {
                if (i >= args.length - 1) continue;
                builder.eventLog(args[i + 1]);
                ++i;
                continue;
            }
            builder.inputFile(args[i]);
        }
        RepositoryValidator validator = builder.build();
        validator.validate();
    }

    private RepositoryValidator(Builder builder) {
        this.eventFile = builder.eventFile;
        this.inputFile = builder.inputFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validate() {
        try (EventListener eventLogger = RepositoryValidatorImpl.createLogger(this.eventFile != null ? new FileOutputStream(this.eventFile) : null);){
            RepositoryValidatorImpl impl = new RepositoryValidatorImpl(eventLogger);
            boolean bl = impl.validate(new FileInputStream(this.inputFile));
            return bl;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return false;
        }
    }

    public static class Builder {
        private String inputFile;
        private String eventFile;

        public RepositoryValidator build() {
            return new RepositoryValidator(this);
        }

        public Builder eventLog(String eventFile) {
            this.eventFile = eventFile;
            return this;
        }

        public Builder inputFile(String inputFilename) {
            this.inputFile = inputFilename;
            return this;
        }
    }
}

