/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.transformers;

import io.fixprotocol._2020.orchestra.repository.Actors;
import io.fixprotocol._2020.orchestra.repository.Categories;
import io.fixprotocol._2020.orchestra.repository.CategoryType;
import io.fixprotocol._2020.orchestra.repository.CodeSets;
import io.fixprotocol._2020.orchestra.repository.ComponentRefType;
import io.fixprotocol._2020.orchestra.repository.ComponentType;
import io.fixprotocol._2020.orchestra.repository.Components;
import io.fixprotocol._2020.orchestra.repository.Datatypes;
import io.fixprotocol._2020.orchestra.repository.FieldRefType;
import io.fixprotocol._2020.orchestra.repository.FieldType;
import io.fixprotocol._2020.orchestra.repository.Fields;
import io.fixprotocol._2020.orchestra.repository.GroupRefType;
import io.fixprotocol._2020.orchestra.repository.GroupType;
import io.fixprotocol._2020.orchestra.repository.Groups;
import io.fixprotocol._2020.orchestra.repository.MessageType;
import io.fixprotocol._2020.orchestra.repository.Messages;
import io.fixprotocol._2020.orchestra.repository.Repository;
import io.fixprotocol._2020.orchestra.repository.Sections;
import io.fixprotocol.orchestra.transformers.AttributeCopyStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvnet.jaxb2_commons.lang.CopyStrategy2;
import org.purl.dc.elements._1.ObjectFactory;
import org.purl.dc.elements._1.SimpleLiteral;
import org.purl.dc.terms.ElementOrRefinementContainer;

public class RepositoryCompressor {
    private static final Logger logger = LogManager.getLogger(RepositoryCompressor.class);
    static final IsCategoryInSection isCategoryInSection = new IsCategoryInSection();
    private final List<BigInteger> componentIdList = new ArrayList<BigInteger>();
    private List<ComponentType> componentList = new ArrayList<ComponentType>();
    private final List<BigInteger> fieldIdList = new ArrayList<BigInteger>();
    private final List<BigInteger> groupIdList = new ArrayList<BigInteger>();
    private List<GroupType> groupList;
    private final String inputFile;
    private final Predicate<MessageType> messagePredicate;
    private final String outputFile;
    private final File logFile;
    private final boolean verbose;

    public static Builder builder() {
        return new Builder();
    }

    public static void main(String[] args) throws Exception {
        RepositoryCompressor compressor = RepositoryCompressor.parseArgs(args).build();
        compressor.compress();
    }

    public static Builder parseArgs(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption(Option.builder((String)"i").desc("path of input file").longOpt("input").numberOfArgs(1).required().build());
        options.addOption(Option.builder((String)"o").desc("path of output file").longOpt("output").numberOfArgs(1).required().build());
        options.addOption(Option.builder((String)"c").desc("select messages by category").longOpt("category").numberOfArgs(1).build());
        options.addOption(Option.builder((String)"s").desc("select messages by section").longOpt("section").numberOfArgs(1).build());
        options.addOption(Option.builder((String)"f").desc("select messages by flow").longOpt("flow").numberOfArgs(1).build());
        options.addOption(Option.builder((String)"n").desc("select messages except category").longOpt("notcategory").numberOfArgs(1).build());
        options.addOption(Option.builder((String)"x").desc("select messages except section").longOpt("notsection").numberOfArgs(1).build());
        options.addOption(Option.builder((String)"?").desc("display usage").longOpt("help").build());
        DefaultParser parser = new DefaultParser();
        Builder builder = new Builder();
        try {
            String section;
            String category;
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("?")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("RepositoryCompressor", options);
                System.exit(0);
            }
            builder.inputFile = cmd.getOptionValue("i");
            builder.outputFile = cmd.getOptionValue("o");
            if (cmd.hasOption("c")) {
                category = cmd.getOptionValue("c");
                builder.messagePredicate = new HasCategory(category);
            }
            if (cmd.hasOption("notcategory")) {
                category = cmd.getOptionValue("notcategory");
                if (builder.messagePredicate == null) {
                    builder.messagePredicate = new NotCategory(category);
                } else {
                    builder.messagePredicate = builder.messagePredicate.and(new NotCategory(category));
                }
            }
            if (cmd.hasOption("s")) {
                section = cmd.getOptionValue("s");
                if (builder.messagePredicate == null) {
                    builder.messagePredicate = new HasSection(section, RepositoryCompressor.isCategoryInSection);
                } else {
                    builder.messagePredicate = builder.messagePredicate.and(new HasSection(section, RepositoryCompressor.isCategoryInSection));
                }
            }
            if (cmd.hasOption("notsection")) {
                section = cmd.getOptionValue("notsection");
                if (builder.messagePredicate == null) {
                    builder.messagePredicate = new NotSection(section, RepositoryCompressor.isCategoryInSection);
                } else {
                    builder.messagePredicate = builder.messagePredicate.and(new NotSection(section, RepositoryCompressor.isCategoryInSection));
                }
            }
            if (cmd.hasOption("f")) {
                String flow = cmd.getOptionValue("f");
                if (builder.messagePredicate == null) {
                    builder.messagePredicate = new HasFlow(flow);
                } else {
                    builder.messagePredicate = builder.messagePredicate.and(new HasFlow(flow));
                }
            }
            if (builder.messagePredicate == null) {
                logger.fatal("RepositoryCompressor invalid arguments; Must select one or more selection criteria: category / section / flow");
                throw new ParseException("Must select one or more selection criteria: category / section / flow");
            }
            return builder;
        }
        catch (ParseException e) {
            logger.fatal("RepositoryCompressor invalid arguments", (Throwable)e);
            throw e;
        }
    }

    static Predicate<? super MessageType> hasFlow() {
        return m -> m.getFlow() != null;
    }

    protected RepositoryCompressor(Builder builder) {
        this.inputFile = builder.inputFile;
        this.outputFile = builder.outputFile;
        this.messagePredicate = builder.messagePredicate;
        this.logFile = builder.logFile != null ? new File(builder.logFile) : null;
        this.verbose = builder.verbose;
    }

    public void compress() throws Exception {
        try (FileInputStream is = new FileInputStream(this.inputFile);
             FileOutputStream os = new FileOutputStream(this.outputFile);){
            this.compress(is, os, this.messagePredicate);
        }
    }

    private void compress(InputStream is, OutputStream os, Predicate<? super MessageType> messagePredicate) throws JAXBException, IOException {
        Components components;
        Level level = this.verbose ? Level.DEBUG : Level.ERROR;
        Repository inRepository = this.unmarshal(is);
        isCategoryInSection.setCategories(inRepository.getCategories().getCategory());
        Repository outRepository = new Repository();
        inRepository.copyTo(null, (Object)outRepository, (CopyStrategy2)AttributeCopyStrategy.INSTANCE);
        ElementOrRefinementContainer metadata = (ElementOrRefinementContainer)inRepository.getMetadata().clone();
        List literals = metadata.getAny();
        ObjectFactory objectFactory = new ObjectFactory();
        SimpleLiteral contributor = new SimpleLiteral();
        contributor.getContent().add("RepositoryCompressor");
        literals.add(objectFactory.createContributor(contributor));
        outRepository.setMetadata(metadata);
        outRepository.setCategories((Categories)inRepository.getCategories().clone());
        outRepository.setSections((Sections)inRepository.getSections().clone());
        outRepository.setDatatypes((Datatypes)inRepository.getDatatypes().clone());
        Actors actors = inRepository.getActors();
        if (actors != null) {
            outRepository.setActors((Actors)actors.clone());
        }
        if ((components = inRepository.getComponents()) != null) {
            Components inComponents = (Components)components.clone();
            this.componentList = inComponents.getComponent();
        }
        Groups inGroups = (Groups)inRepository.getGroups().clone();
        this.groupList = inGroups.getGroup();
        Messages inMessages = (Messages)inRepository.getMessages().clone();
        List messageList = inMessages.getMessage();
        List<MessageType> filteredMessages = messageList.stream().filter(messagePredicate).collect(Collectors.toList());
        filteredMessages.forEach(m -> this.walk(m.getStructure().getComponentRefOrGroupRefOrFieldRef()));
        List distinctFieldIds = this.fieldIdList.stream().distinct().collect(Collectors.toList());
        Fields inFields = (Fields)inRepository.getFields().clone();
        List fieldsWithFlow = inFields.getField().stream().filter(f -> distinctFieldIds.contains(f.getId())).collect(Collectors.toList());
        Fields outFields = new Fields();
        outFields.getField().addAll(fieldsWithFlow);
        outRepository.setFields(outFields);
        List typeList = fieldsWithFlow.stream().map(FieldType::getType).distinct().collect(Collectors.toList());
        CodeSets inCodeSets = (CodeSets)inRepository.getCodeSets().clone();
        List codeSetsWithFlow = inCodeSets.getCodeSet().stream().filter(cs -> typeList.contains(cs.getName())).collect(Collectors.toList());
        CodeSets outCodeSets = new CodeSets();
        outCodeSets.getCodeSet().addAll(codeSetsWithFlow);
        outRepository.setCodeSets(outCodeSets);
        List distinctComponentsIds = this.componentIdList.stream().distinct().collect(Collectors.toList());
        List componentsWithFlow = this.componentList.stream().filter(c -> distinctComponentsIds.contains(c.getId())).collect(Collectors.toList());
        Components outComponents = new Components();
        outComponents.getComponent().addAll(componentsWithFlow);
        outRepository.setComponents(outComponents);
        List distinctGroupIds = this.groupIdList.stream().distinct().collect(Collectors.toList());
        List groupWithFlow = this.groupList.stream().filter(c -> distinctGroupIds.contains(c.getId())).collect(Collectors.toList());
        Groups outGroups = new Groups();
        outGroups.getGroup().addAll(groupWithFlow);
        outRepository.setGroups(outGroups);
        Messages outMessages = new Messages();
        outMessages.getMessage().addAll(filteredMessages);
        outRepository.setMessages(outMessages);
        this.marshal(outRepository, os);
    }

    private ComponentType getComponent(BigInteger id) {
        for (ComponentType component : this.componentList) {
            if (!component.getId().equals(id)) continue;
            return component;
        }
        return null;
    }

    private List<Object> getComponentMembers(BigInteger id) {
        ComponentType component = this.getComponent(id);
        if (component != null) {
            return component.getComponentRefOrGroupRefOrFieldRef();
        }
        return null;
    }

    private GroupType getGroup(BigInteger id) {
        for (GroupType group : this.groupList) {
            if (!group.getId().equals(id)) continue;
            return group;
        }
        return null;
    }

    private List<Object> getGroupMembers(BigInteger id) {
        GroupType component = this.getGroup(id);
        if (component != null) {
            return component.getComponentRefOrGroupRefOrFieldRef();
        }
        return null;
    }

    private void marshal(Repository jaxbElement, OutputStream os) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Repository.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        jaxbMarshaller.marshal((Object)jaxbElement, os);
    }

    private Repository unmarshal(InputStream is) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Repository.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        return (Repository)jaxbUnmarshaller.unmarshal(is);
    }

    private void walk(List<Object> list) {
        for (Object obj : list) {
            if (obj instanceof GroupRefType) {
                GroupRefType groupRef = (GroupRefType)obj;
                GroupType group = this.getGroup(groupRef.getId());
                if (group == null) {
                    logger.error("Group missing for groupRef; ID={}", (Object)groupRef.getId().intValue());
                    return;
                }
                this.fieldIdList.add(group.getNumInGroup().getId());
                this.groupIdList.add(groupRef.getId());
                this.walk(this.getGroupMembers(groupRef.getId()));
                continue;
            }
            if (obj instanceof ComponentRefType) {
                ComponentRefType componentRef = (ComponentRefType)obj;
                this.componentIdList.add(componentRef.getId());
                this.walk(this.getComponentMembers(componentRef.getId()));
                continue;
            }
            if (!(obj instanceof FieldRefType)) continue;
            FieldRefType fieldRef = (FieldRefType)obj;
            this.fieldIdList.add(fieldRef.getId());
        }
    }

    static class NotSection
    implements Predicate<MessageType> {
        private final String section;
        private final BiPredicate<String, String> testCategory;

        public NotSection(String section, BiPredicate<String, String> testCategory) {
            this.section = section;
            this.testCategory = testCategory;
        }

        @Override
        public boolean test(MessageType m) {
            return !this.testCategory.test(m.getCategory(), this.section);
        }
    }

    static class NotCategory
    implements Predicate<MessageType> {
        private final String category;

        public NotCategory(String category) {
            this.category = category;
        }

        @Override
        public boolean test(MessageType m) {
            return !this.category.equals(m.getCategory());
        }
    }

    static class IsCategoryInSection
    implements BiPredicate<String, String> {
        private List<CategoryType> categories;

        IsCategoryInSection() {
        }

        public void setCategories(List<CategoryType> categories) {
            this.categories = categories;
        }

        @Override
        public boolean test(String category, String section) {
            for (CategoryType categoryType : this.categories) {
                if (!categoryType.getName().equals(category) || !categoryType.getSection().equals(section)) continue;
                return true;
            }
            return false;
        }
    }

    static class HasSection
    implements Predicate<MessageType> {
        private final String section;
        private final BiPredicate<String, String> testCategory;

        public HasSection(String section, BiPredicate<String, String> testCategory) {
            this.section = section;
            this.testCategory = testCategory;
        }

        @Override
        public boolean test(MessageType m) {
            return this.testCategory.test(m.getCategory(), this.section);
        }
    }

    static class HasFlow
    implements Predicate<MessageType> {
        private final String flow;

        public HasFlow(String flow) {
            this.flow = flow;
        }

        @Override
        public boolean test(MessageType m) {
            return this.flow.equals(m.getFlow());
        }
    }

    static class HasCategory
    implements Predicate<MessageType> {
        private final String category;

        public HasCategory(String category) {
            this.category = category;
        }

        @Override
        public boolean test(MessageType m) {
            return this.category.equals(m.getCategory());
        }
    }

    public static class Builder {
        private String inputFile;
        private Predicate<MessageType> messagePredicate;
        private String outputFile;
        private String logFile;
        private boolean verbose;

        public RepositoryCompressor build() {
            return new RepositoryCompressor(this);
        }

        public Builder eventLog(String logFile) {
            this.logFile = logFile;
            return this;
        }

        public Builder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        Builder inputFile(String inputFile) {
            this.inputFile = inputFile;
            return this;
        }

        Builder messagePredicate(Predicate<MessageType> messagePredicate) {
            this.messagePredicate = messagePredicate;
            return this;
        }

        Builder outputFile(String outputFile) {
            this.outputFile = outputFile;
            return this;
        }
    }
}

