/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.transformers;

import java.io.File;
import java.util.Arrays;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;

public class RepositoryXslTransformer {
    public static void main(String[] args) throws TransformerException {
        if (args.length < 3) {
            System.out.println("Usage : $<application> [xsl_file_path] [input_xml_file_path] [output_file_path] [param=value]");
            return;
        }
        System.out.println("Received args : \nxslFile = " + args[0] + "\ninputXml = " + args[1] + "\noutputXml = " + args[2]);
        for (int i = 3; i < args.length; ++i) {
            System.out.format("Parameter : %s%n", args[i]);
        }
        RepositoryXslTransformer transformer = new RepositoryXslTransformer();
        transformer.transform(args);
    }

    public void transform(File xsltFile, File inputXml, File outputXml, String[] parameters) throws TransformerException {
        outputXml.getParentFile().mkdirs();
        StreamSource xmlSource = new StreamSource(inputXml);
        StreamSource xsltSource = new StreamSource(xsltFile);
        StreamResult result = new StreamResult(outputXml);
        TransformerFactoryImpl transFact = new TransformerFactoryImpl();
        Transformer trans = transFact.newTransformer(xsltSource);
        for (String parameter : parameters) {
            String[] parts = parameter.split("=");
            trans.setParameter(parts[0], parts[1]);
        }
        trans.transform(xmlSource, result);
    }

    public void transform(String[] args) throws TransformerException {
        File xsltFile = new File(args[0]);
        File inputXml = new File(args[1]);
        File outputXml = new File(args[2]);
        String[] parameters = Arrays.copyOfRange(args, 3, args.length);
        this.transform(xsltFile, inputXml, outputXml, parameters);
    }
}

