/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.dynamodb.driver;

import io.flamingock.commons.utils.RunnerId;
import io.flamingock.core.configurator.core.CoreConfigurable;
import io.flamingock.core.configurator.local.LocalConfigurable;
import io.flamingock.core.engine.local.LocalConnectionEngine;
import io.flamingock.core.engine.local.driver.ConnectionDriver;
import io.flamingock.oss.driver.dynamodb.DynamoDBConfiguration;
import io.flamingock.oss.driver.dynamodb.internal.DynamoDBEngine;
import io.flamingock.oss.driver.dynamodb.internal.util.DynamoClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

public class DynamoDBDriver
implements ConnectionDriver<DynamoDBConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDBDriver.class);
    private final DynamoClients client;
    private DynamoDBConfiguration driverConfiguration;

    public DynamoDBDriver(DynamoDbClient client) {
        this.client = new DynamoClients(client);
    }

    @Deprecated
    public static DynamoDBDriver withLockStrategy(DynamoDbClient client, @Deprecated long lockAcquiredForMillis, @Deprecated long lockQuitTryingAfterMillis, @Deprecated long lockTryFrequencyMillis) {
        DynamoDBDriver.logWarningFieldIgnored("lockAcquiredForMillis", lockAcquiredForMillis);
        DynamoDBDriver.logWarningFieldIgnored("lockQuitTryingAfterMillis", lockQuitTryingAfterMillis);
        DynamoDBDriver.logWarningFieldIgnored("lockTryFrequencyMillis", lockTryFrequencyMillis);
        return new DynamoDBDriver(client);
    }

    @Deprecated
    public static DynamoDBDriver withDefaultLock(DynamoDbClient client) {
        return new DynamoDBDriver(client);
    }

    private static void logWarningFieldIgnored(String name, long value) {
        logger.warn("Parameter[{}] with value[{}] will be ignored. It needs to be injected in the configuration", (Object)name, (Object)value);
    }

    public DynamoDBDriver setDriverConfiguration(DynamoDBConfiguration driverConfiguration) {
        this.driverConfiguration = driverConfiguration;
        return this;
    }

    public LocalConnectionEngine initializeAndGetEngine(RunnerId runnerId, CoreConfigurable coreConfiguration, LocalConfigurable communityConfiguration) {
        DynamoDBEngine dynamodbEngine = new DynamoDBEngine(this.client, coreConfiguration, communityConfiguration, this.driverConfiguration != null ? this.driverConfiguration : DynamoDBConfiguration.getDefault());
        dynamodbEngine.initialize(runnerId);
        return dynamodbEngine;
    }
}

