/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.dynamodb.internal;

import io.flamingock.commons.utils.Result;
import io.flamingock.community.internal.TransactionManager;
import io.flamingock.core.engine.audit.writer.AuditEntry;
import io.flamingock.core.engine.audit.writer.AuditStageStatus;
import io.flamingock.core.engine.local.Auditor;
import io.flamingock.oss.driver.dynamodb.internal.entities.AuditEntryEntity;
import io.flamingock.oss.driver.dynamodb.internal.util.DynamoClients;
import io.flamingock.oss.driver.dynamodb.internal.util.DynamoDBUtil;
import java.util.Collections;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.model.PutItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.ScanEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.TransactWriteItemsEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;

public class DynamoDBAuditor
implements Auditor {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDBAuditor.class);
    protected final DynamoClients client;
    private final DynamoDBUtil dynamoDBUtil = new DynamoDBUtil();
    protected DynamoDbTable<AuditEntryEntity> table;
    protected final TransactionManager<TransactWriteItemsEnhancedRequest.Builder> transactionManager;

    protected DynamoDBAuditor(DynamoClients client, TransactionManager<TransactWriteItemsEnhancedRequest.Builder> transactionManager) {
        this.client = client;
        this.transactionManager = transactionManager;
    }

    protected void initialize(Boolean indexCreation) {
        if (indexCreation.booleanValue()) {
            this.dynamoDBUtil.createTable(this.client.getDynamoDbClient(), this.dynamoDBUtil.getAttributeDefinitions("partitionKey", null, new String[0]), this.dynamoDBUtil.getKeySchemas("partitionKey", null), this.dynamoDBUtil.getProvisionedThroughput(5L, 5L), "flamingock_audit_log", Collections.emptyList(), Collections.emptyList());
        }
        this.table = this.client.getEnhancedClient().table("flamingock_audit_log", (TableSchema)TableSchema.fromBean(AuditEntryEntity.class));
    }

    public void deleteAll() {
        this.table.deleteTable();
        this.initialize(true);
    }

    public Result writeEntry(AuditEntry auditEntry) {
        AuditEntryEntity entity = new AuditEntryEntity(auditEntry);
        logger.debug("Saving audit entry with key {}", (Object)entity.getPartitionKey());
        TransactWriteItemsEnhancedRequest.Builder transactionBuilder = this.transactionManager.getSession(auditEntry.getTaskId()).orElse(null);
        if (transactionBuilder != null) {
            transactionBuilder.addPutItem(this.table, (Object)entity);
        } else {
            try {
                this.table.putItem(PutItemEnhancedRequest.builder(AuditEntryEntity.class).item((Object)entity).build());
            }
            catch (ConditionalCheckFailedException ex) {
                logger.warn("Error saving audit entry with key {}", (Object)entity.getPartitionKey(), (Object)ex);
                throw ex;
            }
        }
        return Result.OK();
    }

    public AuditStageStatus getAuditStageStatus() {
        AuditStageStatus.EntryBuilder response = AuditStageStatus.entryBuilder();
        this.table.scan(ScanEnhancedRequest.builder().consistentRead(Boolean.valueOf(true)).build()).items().stream().map(AuditEntryEntity::toAuditEntry).collect(Collectors.toList()).forEach(arg_0 -> ((AuditStageStatus.EntryBuilder)response).addEntry(arg_0));
        return response.build();
    }
}

