/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.dynamodb.internal;

import io.flamingock.commons.utils.RunnerId;
import io.flamingock.commons.utils.TimeService;
import io.flamingock.community.internal.LocalExecutionPlanner;
import io.flamingock.community.internal.TransactionManager;
import io.flamingock.community.internal.lock.LocalLockService;
import io.flamingock.core.configurator.core.CoreConfigurable;
import io.flamingock.core.configurator.local.LocalConfigurable;
import io.flamingock.core.engine.audit.AuditReader;
import io.flamingock.core.engine.audit.AuditWriter;
import io.flamingock.core.engine.local.LocalConnectionEngine;
import io.flamingock.core.transaction.TransactionWrapper;
import io.flamingock.oss.driver.dynamodb.DynamoDBConfiguration;
import io.flamingock.oss.driver.dynamodb.internal.DynamoDBAuditor;
import io.flamingock.oss.driver.dynamodb.internal.DynamoDBLockService;
import io.flamingock.oss.driver.dynamodb.internal.DynamoDBTransactionWrapper;
import io.flamingock.oss.driver.dynamodb.internal.mongock.ChangeEntryDynamoDB;
import io.flamingock.oss.driver.dynamodb.internal.mongock.MongockImporterModule;
import io.flamingock.oss.driver.dynamodb.internal.util.DynamoClients;
import java.util.Optional;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.model.TransactWriteItemsEnhancedRequest;

public class DynamoDBEngine
implements LocalConnectionEngine {
    private final DynamoClients client;
    private final LocalConfigurable localConfiguration;
    private final DynamoDBConfiguration driverConfiguration;
    private final CoreConfigurable coreConfiguration;
    private DynamoDBAuditor auditor;
    private LocalExecutionPlanner executionPlanner;
    private TransactionWrapper transactionWrapper;
    private MongockImporterModule mongockImporter = null;

    public DynamoDBEngine(DynamoClients client, CoreConfigurable coreConfiguration, LocalConfigurable localConfiguration, DynamoDBConfiguration driverConfiguration) {
        this.client = client;
        this.driverConfiguration = driverConfiguration;
        this.coreConfiguration = coreConfiguration;
        this.localConfiguration = localConfiguration;
    }

    public void initialize(RunnerId runnerId) {
        TransactionManager transactionManager = new TransactionManager(TransactWriteItemsEnhancedRequest::builder);
        this.transactionWrapper = this.coreConfiguration.getTransactionEnabled() != false ? new DynamoDBTransactionWrapper(this.client, (TransactionManager<TransactWriteItemsEnhancedRequest.Builder>)transactionManager) : null;
        this.auditor = new DynamoDBAuditor(this.client, (TransactionManager<TransactWriteItemsEnhancedRequest.Builder>)transactionManager);
        this.auditor.initialize(this.driverConfiguration.isIndexCreation());
        DynamoDBLockService lockService = new DynamoDBLockService(this.client, TimeService.getDefault());
        lockService.initialize(this.driverConfiguration.isIndexCreation());
        this.executionPlanner = new LocalExecutionPlanner(runnerId, (LocalLockService)lockService, (AuditReader)this.auditor, this.coreConfiguration);
        if (this.coreConfiguration.isMongockImporterEnabled()) {
            DynamoDbTable sourceTable = this.client.getEnhancedClient().table(this.coreConfiguration.getLegacyMongockChangelogSource(), (TableSchema)TableSchema.fromBean(ChangeEntryDynamoDB.class));
            this.mongockImporter = new MongockImporterModule((DynamoDbTable<ChangeEntryDynamoDB>)sourceTable, (AuditWriter)this.auditor);
        }
    }

    public DynamoDBAuditor getAuditor() {
        return this.auditor;
    }

    public LocalExecutionPlanner getExecutionPlanner() {
        return this.executionPlanner;
    }

    public Optional<TransactionWrapper> getTransactionWrapper() {
        return Optional.ofNullable(this.transactionWrapper);
    }

    public Optional<MongockImporterModule> getMongockLegacyImporterModule() {
        return Optional.ofNullable(this.mongockImporter);
    }
}

