/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.dynamodb.internal;

import io.flamingock.commons.utils.RunnerId;
import io.flamingock.commons.utils.TimeService;
import io.flamingock.community.internal.lock.LocalLockService;
import io.flamingock.community.internal.lock.LockEntry;
import io.flamingock.core.engine.lock.LockAcquisition;
import io.flamingock.core.engine.lock.LockKey;
import io.flamingock.core.engine.lock.LockServiceException;
import io.flamingock.core.engine.lock.LockStatus;
import io.flamingock.oss.driver.dynamodb.internal.entities.LockEntryEntity;
import io.flamingock.oss.driver.dynamodb.internal.util.DynamoClients;
import io.flamingock.oss.driver.dynamodb.internal.util.DynamoDBUtil;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.model.PutItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.UpdateItemEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class DynamoDBLockService
implements LocalLockService {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDBLockService.class);
    protected final DynamoClients client;
    private final TimeService timeService;
    private final DynamoDBUtil dynamoDBUtil = new DynamoDBUtil();
    protected DynamoDbTable<LockEntryEntity> table;

    protected DynamoDBLockService(DynamoClients client, TimeService timeService) {
        this.client = client;
        this.timeService = timeService;
    }

    protected void initialize(Boolean indexCreation) {
        if (indexCreation.booleanValue()) {
            this.dynamoDBUtil.createTable(this.client.getDynamoDbClient(), this.dynamoDBUtil.getAttributeDefinitions("partitionKey", null, new String[0]), this.dynamoDBUtil.getKeySchemas("partitionKey", null), this.dynamoDBUtil.getProvisionedThroughput(5L, 5L), "locks", Collections.emptyList(), Collections.emptyList());
        }
        this.table = this.client.getEnhancedClient().table("locks", (TableSchema)TableSchema.fromBean(LockEntryEntity.class));
    }

    public LockAcquisition upsert(LockKey key, RunnerId owner, long leaseMillis) {
        LockEntry newLock = new LockEntry(key.toString(), LockStatus.LOCK_HELD, owner.toString(), this.timeService.currentDatePlusMillis(leaseMillis));
        this.table.putItem(PutItemEnhancedRequest.builder(LockEntryEntity.class).item((Object)new LockEntryEntity(newLock)).conditionExpression(Expression.builder().expression("attribute_not_exists(partitionKey) OR (lockOwner = :ownerVal AND expiresAt > :currentTime) OR (expiresAt < :currentTime)").putExpressionValue(":ownerVal", (AttributeValue)AttributeValue.builder().s(newLock.getOwner()).build()).putExpressionValue(":currentTime", (AttributeValue)AttributeValue.builder().n(String.valueOf(Timestamp.valueOf(LocalDateTime.now()).getTime())).build()).build()).build());
        return new LockAcquisition(owner, leaseMillis);
    }

    public LockAcquisition extendLock(LockKey key, RunnerId owner, long leaseMillis) throws LockServiceException {
        LockEntry updatedLock = new LockEntry(key.toString(), LockStatus.LOCK_HELD, owner.toString(), this.timeService.currentDatePlusMillis(leaseMillis));
        this.table.updateItem(UpdateItemEnhancedRequest.builder(LockEntryEntity.class).item((Object)new LockEntryEntity(updatedLock)).conditionExpression(Expression.builder().expression("attribute_exists(partitionKey) AND lockOwner = :ownerVal AND expiresAt > :currentTime").putExpressionValue(":ownerVal", (AttributeValue)AttributeValue.builder().s(updatedLock.getOwner()).build()).putExpressionValue(":currentTime", (AttributeValue)AttributeValue.builder().n(String.valueOf(Timestamp.valueOf(LocalDateTime.now()).getTime())).build()).build()).build());
        return new LockAcquisition(owner, leaseMillis);
    }

    public LockAcquisition getLock(LockKey lockKey) {
        LockEntryEntity existingLockEntity = (LockEntryEntity)this.table.getItem(Key.builder().partitionValue(lockKey.toString()).build());
        if (existingLockEntity != null) {
            return existingLockEntity.getlockAcquisition();
        }
        logger.debug("Lock for key {} was not found.", (Object)lockKey);
        return null;
    }

    public void releaseLock(LockKey lockKey, RunnerId owner) {
        LockEntryEntity existingLockEntity = (LockEntryEntity)this.table.getItem(Key.builder().partitionValue(lockKey.toString()).build());
        if (existingLockEntity != null) {
            LockEntry existingLock = existingLockEntity.toLockEntry();
            if (owner.equals((Object)RunnerId.fromString((String)existingLock.getOwner()))) {
                logger.debug("Lock for key {} belongs to us, so removing.", (Object)lockKey);
                this.table.deleteItem(Key.builder().partitionValue(lockKey.toString()).build());
            } else {
                logger.debug("Lock for key {} belongs to other owner, can not delete.", (Object)existingLock.getKey());
            }
        } else {
            logger.debug("Lock for key {} is not found, nothing to do", (Object)lockKey);
        }
    }
}

