/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.dynamodb.internal;

import io.flamingock.community.internal.TransactionManager;
import io.flamingock.core.runtime.dependency.DependencyInjectable;
import io.flamingock.core.task.descriptor.TaskDescriptor;
import io.flamingock.core.task.navigation.step.FailedStep;
import io.flamingock.core.transaction.TransactionWrapper;
import io.flamingock.oss.driver.dynamodb.internal.util.DynamoClients;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.enhanced.dynamodb.model.TransactWriteItemsEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactionCanceledException;

public class DynamoDBTransactionWrapper
implements TransactionWrapper {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDBTransactionWrapper.class);
    private final DynamoClients client;
    protected final TransactionManager<TransactWriteItemsEnhancedRequest.Builder> transactionManager;

    DynamoDBTransactionWrapper(DynamoClients client, TransactionManager<TransactWriteItemsEnhancedRequest.Builder> transactionManager) {
        this.client = client;
        this.transactionManager = transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T wrapInTransaction(TaskDescriptor taskDescriptor, DependencyInjectable dependencyInjectable, Supplier<T> operation) {
        String sessionId = taskDescriptor.getId();
        try {
            TransactWriteItemsEnhancedRequest.Builder writeRequestBuilder = (TransactWriteItemsEnhancedRequest.Builder)this.transactionManager.startSession(sessionId);
            dependencyInjectable.addDependency((Object)writeRequestBuilder);
            T result = operation.get();
            if (!(result instanceof FailedStep)) {
                try {
                    this.client.getEnhancedClient().transactWriteItems(writeRequestBuilder.build());
                }
                catch (TransactionCanceledException ex) {
                    ex.cancellationReasons().forEach(cancellationReason -> logger.info(cancellationReason.toString()));
                }
            }
            T t = result;
            return t;
        }
        finally {
            this.transactionManager.closeSession(sessionId);
        }
    }
}

