/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.dynamodb.internal.entities;

import io.flamingock.core.engine.audit.writer.AuditEntry;
import java.time.LocalDateTime;
import java.util.Objects;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbBean;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbPartitionKey;

@DynamoDbBean
public class AuditEntryEntity {
    protected Boolean systemChange;
    private String partitionKey;
    private String taskId;
    private String stageId;
    private String executionId;
    private String author;
    private LocalDateTime createdAt;
    private AuditEntry.Status state;
    private String className;
    private String methodName;
    private Object metadata;
    private Long executionMillis;
    private String executionHostname;
    private Object errorTrace;
    private AuditEntry.ExecutionType type;

    public AuditEntryEntity(AuditEntry auditEntry) {
        this.partitionKey = AuditEntryEntity.partitionKey(auditEntry.getExecutionId(), auditEntry.getTaskId(), auditEntry.getState());
        this.taskId = auditEntry.getTaskId();
        this.stageId = auditEntry.getStageId();
        this.executionId = auditEntry.getExecutionId();
        this.author = auditEntry.getAuthor();
        this.createdAt = auditEntry.getCreatedAt();
        this.state = auditEntry.getState();
        this.className = auditEntry.getClassName();
        this.methodName = auditEntry.getMethodName();
        this.metadata = auditEntry.getMetadata();
        this.executionMillis = auditEntry.getExecutionMillis();
        this.executionHostname = auditEntry.getExecutionHostname();
        this.errorTrace = auditEntry.getErrorTrace();
        this.type = auditEntry.getType();
        this.systemChange = auditEntry.getSystemChange();
    }

    public AuditEntryEntity() {
    }

    public static String partitionKey(String executionId, String taskId, AuditEntry.Status state) {
        return executionId + '#' + taskId + '#' + state.name();
    }

    @DynamoDbPartitionKey
    @DynamoDbAttribute(value="partitionKey")
    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    @DynamoDbAttribute(value="changeId")
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @DynamoDbAttribute(value="stageId")
    public String getStageId() {
        return this.stageId;
    }

    public void setStageId(String stageId) {
        this.stageId = stageId;
    }

    @DynamoDbAttribute(value="executionId")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @DynamoDbAttribute(value="author")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @DynamoDbAttribute(value="timestamp")
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @DynamoDbAttribute(value="state")
    public String getState() {
        return this.state.name();
    }

    public void setState(String state) {
        this.state = AuditEntry.Status.valueOf((String)state);
    }

    @DynamoDbAttribute(value="changeLogClass")
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @DynamoDbAttribute(value="changeSetMethod")
    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @DynamoDbAttribute(value="metadata")
    public String getMetadata() {
        return this.metadata.toString();
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    @DynamoDbAttribute(value="executionMillis")
    public Long getExecutionMillis() {
        return this.executionMillis;
    }

    public void setExecutionMillis(Long executionMillis) {
        this.executionMillis = executionMillis;
    }

    @DynamoDbAttribute(value="executionHostname")
    public String getExecutionHostname() {
        return this.executionHostname;
    }

    public void setExecutionHostname(String executionHostname) {
        this.executionHostname = executionHostname;
    }

    @DynamoDbAttribute(value="errorTrace")
    public String getErrorTrace() {
        return this.errorTrace.toString();
    }

    public void setErrorTrace(Object errorTrace) {
        this.errorTrace = errorTrace;
    }

    @DynamoDbAttribute(value="type")
    public String getType() {
        return this.type.name();
    }

    public void setType(String type) {
        this.type = AuditEntry.ExecutionType.valueOf((String)type);
    }

    @DynamoDbAttribute(value="systemChange")
    public Boolean getSystemChange() {
        return this.systemChange;
    }

    public void setSystemChange(Boolean systemChange) {
        this.systemChange = systemChange;
    }

    public AuditEntry toAuditEntry() {
        return new AuditEntry(this.executionId, this.stageId, this.taskId, this.author, this.createdAt, this.state, this.type, this.className, this.methodName, this.executionMillis.longValue(), this.executionHostname, this.metadata, this.systemChange.booleanValue(), Objects.toString(this.errorTrace, ""));
    }
}

