/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.dynamodb.internal.entities;

import io.flamingock.commons.utils.RunnerId;
import io.flamingock.community.internal.lock.LockEntry;
import io.flamingock.core.engine.lock.LockAcquisition;
import io.flamingock.core.engine.lock.LockStatus;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbBean;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbPartitionKey;

@DynamoDbBean
public class LockEntryEntity {
    private String partitionKey;
    private String key;
    private LockStatus status;
    private String lockOwner;
    private LocalDateTime expiresAt;

    public LockEntryEntity(LockEntry lock) {
        this.partitionKey = lock.getKey();
        this.key = lock.getKey();
        this.status = lock.getStatus();
        this.lockOwner = lock.getOwner();
        this.expiresAt = lock.getExpiresAt();
    }

    public LockEntryEntity() {
    }

    @DynamoDbPartitionKey
    @DynamoDbAttribute(value="partitionKey")
    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    @DynamoDbAttribute(value="key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @DynamoDbAttribute(value="status")
    public LockStatus getStatus() {
        return this.status;
    }

    public void setStatus(LockStatus status) {
        this.status = status;
    }

    @DynamoDbAttribute(value="lockOwner")
    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    @DynamoDbAttribute(value="expiresAt")
    public Long getExpiresAt() {
        return Timestamp.valueOf(this.expiresAt).getTime();
    }

    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = LocalDateTime.ofInstant(Instant.ofEpochMilli(expiresAt), ZoneId.systemDefault());
    }

    public LockEntry toLockEntry() {
        return new LockEntry(this.key, this.status, this.lockOwner, this.expiresAt);
    }

    public LockAcquisition getlockAcquisition() {
        long expiration = this.expiresAt.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        long now = LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        long diffMillis = expiration - now;
        return new LockAcquisition(RunnerId.fromString((String)this.lockOwner), diffMillis);
    }
}

