/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.dynamodb.internal.mongock;

import io.flamingock.core.api.LocalSystemModule;
import io.flamingock.core.engine.audit.AuditWriter;
import io.flamingock.core.runtime.dependency.Dependency;
import io.flamingock.oss.driver.dynamodb.internal.mongock.ChangeEntryDynamoDB;
import io.flamingock.oss.driver.dynamodb.internal.mongock.InternalMongockImporterConfiguration;
import io.flamingock.oss.driver.dynamodb.internal.mongock.MongockLocalLegacyImporterChangeUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;

public class MongockImporterModule
implements LocalSystemModule {
    public static final List<Class<?>> TASK_CLASSES = Collections.singletonList(MongockLocalLegacyImporterChangeUnit.class);
    private List<Dependency> dependencies;
    private final DynamoDbTable<ChangeEntryDynamoDB> sourceTable;
    private final AuditWriter auditWriter;

    public MongockImporterModule(DynamoDbTable<ChangeEntryDynamoDB> sourceTable, AuditWriter auditWriter) {
        this.sourceTable = sourceTable;
        this.auditWriter = auditWriter;
    }

    public void initialise() {
        InternalMongockImporterConfiguration configuration = new InternalMongockImporterConfiguration(this.sourceTable, this.auditWriter);
        this.dependencies = Collections.singletonList(new Dependency(InternalMongockImporterConfiguration.class, (Object)configuration));
    }

    public String getName() {
        return "dynamodb-local-legacy-importer";
    }

    public Collection<Class<?>> getTaskClasses() {
        return TASK_CLASSES;
    }

    public int getOrder() {
        return 0;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public boolean isBeforeUserStages() {
        return true;
    }
}

