/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.dynamodb.internal.mongock;

import io.flamingock.core.api.annotations.ChangeUnit;
import io.flamingock.core.api.annotations.Execution;
import io.flamingock.core.api.annotations.SystemChange;
import io.flamingock.core.engine.audit.AuditWriter;
import io.flamingock.core.engine.audit.legacy.mongock.ChangeEntry;
import io.flamingock.core.engine.audit.legacy.mongock.ChangeState;
import io.flamingock.core.engine.audit.legacy.mongock.ChangeType;
import io.flamingock.core.engine.audit.writer.AuditEntry;
import io.flamingock.core.legacy.MongockLegacyIdGenerator;
import io.flamingock.oss.driver.dynamodb.internal.mongock.ChangeEntryDynamoDB;
import io.flamingock.oss.driver.dynamodb.internal.mongock.InternalMongockImporterConfiguration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.model.ScanEnhancedRequest;

@SystemChange
@ChangeUnit(id="mongock-local-legacy-importer-dynamodb", order="1")
public class MongockLocalLegacyImporterChangeUnit {
    @Execution
    public void execution(InternalMongockImporterConfiguration configuration) {
        DynamoDbTable<ChangeEntryDynamoDB> sourceTable = configuration.getSourceTable();
        if (sourceTable == null) {
            throw new RuntimeException("SourceTable not injected");
        }
        AuditWriter auditWriter = configuration.getAuditWriter();
        if (auditWriter == null) {
            throw new RuntimeException("AuditWriter not injected");
        }
        List<AuditEntry> collect = sourceTable.scan(ScanEnhancedRequest.builder().consistentRead(Boolean.valueOf(true)).build()).items().stream().map(MongockLocalLegacyImporterChangeUnit::toChangeEntry).map(MongockLocalLegacyImporterChangeUnit::toAuditEntry).collect(Collectors.toList());
        collect.forEach(arg_0 -> ((AuditWriter)auditWriter).writeEntry(arg_0));
    }

    private static ChangeEntry toChangeEntry(ChangeEntryDynamoDB changeEntryDynamoDB) {
        Date timestamp = Date.from(Instant.ofEpochMilli(changeEntryDynamoDB.getTimestamp()));
        String id = MongockLegacyIdGenerator.getNewId((String)changeEntryDynamoDB.getChangeId(), (String)changeEntryDynamoDB.getAuthor());
        return new ChangeEntry(changeEntryDynamoDB.getExecutionId(), id, changeEntryDynamoDB.getAuthor(), timestamp, ChangeState.valueOf((String)changeEntryDynamoDB.getState()), ChangeType.valueOf((String)changeEntryDynamoDB.getType()), changeEntryDynamoDB.getChangeLogClass(), changeEntryDynamoDB.getChangeSetMethod(), (Object)changeEntryDynamoDB.getMetadata(), changeEntryDynamoDB.getExecutionMillis().longValue(), changeEntryDynamoDB.getExecutionHostname(), changeEntryDynamoDB.getErrorTrace(), changeEntryDynamoDB.getSystemChange(), timestamp);
    }

    private static AuditEntry toAuditEntry(ChangeEntry changeEntry) {
        LocalDateTime timestamp = Instant.ofEpochMilli(changeEntry.getTimestamp().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
        if (changeEntry.getState() == ChangeState.IGNORED) {
            return null;
        }
        return new AuditEntry(changeEntry.getExecutionId(), null, changeEntry.getChangeId(), changeEntry.getAuthor(), timestamp, changeEntry.getState().toAuditStatus(), changeEntry.getType().toAuditType(), changeEntry.getChangeLogClass(), changeEntry.getChangeSetMethod(), changeEntry.getExecutionMillis(), changeEntry.getExecutionHostname(), changeEntry.getMetadata(), changeEntry.getSystemChange().booleanValue(), changeEntry.getErrorTrace());
    }
}

