/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.dynamodb.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;

public final class DynamoDBUtil {
    public List<AttributeDefinition> getAttributeDefinitions(String pkName, String skName, String ... vargs) {
        ArrayList<AttributeDefinition> result = new ArrayList<AttributeDefinition>();
        result.add((AttributeDefinition)AttributeDefinition.builder().attributeName(pkName).attributeType(ScalarAttributeType.S).build());
        if (skName != null) {
            result.add((AttributeDefinition)AttributeDefinition.builder().attributeName(skName).attributeType(ScalarAttributeType.S).build());
        }
        for (String arg : vargs) {
            result.add((AttributeDefinition)AttributeDefinition.builder().attributeName(arg).attributeType(ScalarAttributeType.S).build());
        }
        return result;
    }

    public List<KeySchemaElement> getKeySchemas(String pkName, String skName) {
        ArrayList<KeySchemaElement> result = new ArrayList<KeySchemaElement>();
        result.add((KeySchemaElement)KeySchemaElement.builder().attributeName(pkName).keyType(KeyType.HASH).build());
        if (skName != null) {
            result.add((KeySchemaElement)KeySchemaElement.builder().attributeName(skName).keyType(KeyType.RANGE).build());
        }
        return result;
    }

    public ProvisionedThroughput getProvisionedThroughput(Long readCap, Long writeCap) {
        return (ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(readCap).writeCapacityUnits(writeCap).build();
    }

    public LocalSecondaryIndex generateLSI(String lsiName, String lsiPK, String lsiSK) {
        return (LocalSecondaryIndex)LocalSecondaryIndex.builder().indexName(lsiName).keySchema(Arrays.asList((KeySchemaElement)KeySchemaElement.builder().attributeName(lsiPK).keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName(lsiSK).keyType(KeyType.RANGE).build())).projection((Projection)Projection.builder().projectionType(ProjectionType.ALL).build()).build();
    }

    public void createTable(DynamoDbClient dynamoDbClient, List<AttributeDefinition> attributeDefinitions, List<KeySchemaElement> keySchemas, ProvisionedThroughput provisionedVal, String tableName, List<LocalSecondaryIndex> localSecondaryIndexes, List<GlobalSecondaryIndex> globalSecondaryIndexes) {
        try {
            CreateTableRequest.Builder createBuilder = CreateTableRequest.builder().attributeDefinitions(attributeDefinitions).keySchema(keySchemas).provisionedThroughput(provisionedVal).tableName(tableName);
            if (!localSecondaryIndexes.isEmpty()) {
                createBuilder.localSecondaryIndexes(localSecondaryIndexes);
            }
            if (!globalSecondaryIndexes.isEmpty()) {
                createBuilder.globalSecondaryIndexes(globalSecondaryIndexes);
            }
            dynamoDbClient.createTable((CreateTableRequest)createBuilder.build());
            DescribeTableRequest tableRequest = (DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build();
            dynamoDbClient.waiter().waitUntilTableExists(tableRequest).matched();
        }
        catch (ResourceInUseException resourceInUseException) {
            // empty catch block
        }
    }
}

