/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.mongodb.springdata.v3.driver;

import io.flamingock.commons.utils.RunnerId;
import io.flamingock.core.configurator.core.CoreConfigurable;
import io.flamingock.core.configurator.local.LocalConfigurable;
import io.flamingock.core.engine.local.LocalConnectionEngine;
import io.flamingock.core.engine.local.driver.ConnectionDriver;
import io.flamingock.oss.driver.mongodb.springdata.v3.config.SpringDataMongoV3Configuration;
import io.flamingock.oss.driver.mongodb.springdata.v3.internal.SpringDataMongoV3Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;

public class SpringDataMongoV3Driver
implements ConnectionDriver<SpringDataMongoV3Configuration> {
    private static final Logger logger = LoggerFactory.getLogger(SpringDataMongoV3Driver.class);
    private final MongoTemplate mongoTemplate;
    private SpringDataMongoV3Configuration driverConfiguration;

    @Deprecated
    public static SpringDataMongoV3Driver withLockStrategy(MongoTemplate mongoTemplate, @Deprecated long lockAcquiredForMillis, @Deprecated long lockQuitTryingAfterMillis, @Deprecated long lockTryFrequencyMillis) {
        SpringDataMongoV3Driver.logWarningFieldIgnored("lockAcquiredForMillis", lockAcquiredForMillis);
        SpringDataMongoV3Driver.logWarningFieldIgnored("lockQuitTryingAfterMillis", lockQuitTryingAfterMillis);
        SpringDataMongoV3Driver.logWarningFieldIgnored("lockTryFrequencyMillis", lockTryFrequencyMillis);
        return new SpringDataMongoV3Driver(mongoTemplate);
    }

    @Deprecated
    public static SpringDataMongoV3Driver withDefaultLock(MongoTemplate mongoTemplate) {
        return new SpringDataMongoV3Driver(mongoTemplate);
    }

    public SpringDataMongoV3Driver(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public SpringDataMongoV3Driver setDriverConfiguration(SpringDataMongoV3Configuration driverConfiguration) {
        this.driverConfiguration = driverConfiguration;
        return this;
    }

    public LocalConnectionEngine initializeAndGetEngine(RunnerId runnerId, CoreConfigurable coreConfiguration, LocalConfigurable communityConfiguration) {
        SpringDataMongoV3Engine engine = new SpringDataMongoV3Engine(this.mongoTemplate, coreConfiguration, communityConfiguration, this.driverConfiguration != null ? this.driverConfiguration : SpringDataMongoV3Configuration.getDefault());
        engine.initialize(runnerId);
        return engine;
    }

    private static void logWarningFieldIgnored(String name, long value) {
        logger.warn("Parameter[{}] with value[{}] will be ignored. It needs to be injected in the configuration", (Object)name, (Object)value);
    }
}

