/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.mongodb.springdata.v3.internal;

import com.mongodb.ReadConcern;
import com.mongodb.client.MongoCollection;
import io.flamingock.commons.utils.RunnerId;
import io.flamingock.community.internal.LocalExecutionPlanner;
import io.flamingock.community.internal.lock.LocalLockService;
import io.flamingock.core.configurator.core.CoreConfigurable;
import io.flamingock.core.configurator.local.LocalConfigurable;
import io.flamingock.core.engine.audit.AuditReader;
import io.flamingock.core.engine.audit.AuditWriter;
import io.flamingock.core.engine.local.Auditor;
import io.flamingock.core.engine.local.LocalConnectionEngine;
import io.flamingock.core.transaction.TransactionWrapper;
import io.flamingock.oss.driver.mongodb.springdata.v3.config.SpringDataMongoV3Configuration;
import io.flamingock.oss.driver.mongodb.springdata.v3.internal.SpringDataMongoV3Auditor;
import io.flamingock.oss.driver.mongodb.springdata.v3.internal.SpringDataMongoV3LockService;
import io.flamingock.oss.driver.mongodb.springdata.v3.internal.SpringDataMongoV3TransactionWrapper;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongock.MongockImporterModule;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongodb.ReadWriteConfiguration;
import java.util.Optional;
import org.springframework.data.mongodb.core.MongoTemplate;

public class SpringDataMongoV3Engine
implements LocalConnectionEngine {
    private final MongoTemplate mongoTemplate;
    private final LocalConfigurable localConfiguration;
    private SpringDataMongoV3Auditor auditor;
    private LocalExecutionPlanner executionPlanner;
    private TransactionWrapper transactionWrapper;
    private MongockImporterModule mongockImporter = null;
    private final SpringDataMongoV3Configuration driverConfiguration;
    private final CoreConfigurable coreConfiguration;

    public SpringDataMongoV3Engine(MongoTemplate mongoTemplate, CoreConfigurable coreConfiguration, LocalConfigurable localConfiguration, SpringDataMongoV3Configuration driverConfiguration) {
        this.mongoTemplate = mongoTemplate;
        this.driverConfiguration = driverConfiguration;
        this.coreConfiguration = coreConfiguration;
        this.localConfiguration = localConfiguration;
    }

    public void initialize(RunnerId runnerId) {
        ReadWriteConfiguration readWriteConfiguration = new ReadWriteConfiguration(this.driverConfiguration.getBuiltMongoDBWriteConcern(), new ReadConcern(this.driverConfiguration.getReadConcern()), this.driverConfiguration.getReadPreference().getValue());
        this.transactionWrapper = this.coreConfiguration.getTransactionEnabled() != false ? new SpringDataMongoV3TransactionWrapper(this.mongoTemplate, readWriteConfiguration) : null;
        this.auditor = new SpringDataMongoV3Auditor(this.mongoTemplate, this.driverConfiguration.getMigrationRepositoryName(), readWriteConfiguration);
        this.auditor.initialize(this.driverConfiguration.isIndexCreation());
        SpringDataMongoV3LockService lockService = new SpringDataMongoV3LockService(this.mongoTemplate.getDb(), this.driverConfiguration.getLockRepositoryName(), readWriteConfiguration);
        lockService.initialize(this.driverConfiguration.isIndexCreation());
        this.executionPlanner = new LocalExecutionPlanner(runnerId, (LocalLockService)lockService, (AuditReader)this.auditor, this.coreConfiguration);
        if (this.coreConfiguration.getMongockImporterConfiguration().isEnabled()) {
            MongoCollection collection = this.mongoTemplate.getCollection(this.coreConfiguration.getMongockImporterConfiguration().getSourceName());
            this.mongockImporter = new MongockImporterModule(collection, (AuditWriter)this.auditor);
        }
    }

    public Auditor getAuditor() {
        return this.auditor;
    }

    public LocalExecutionPlanner getExecutionPlanner() {
        return this.executionPlanner;
    }

    public Optional<TransactionWrapper> getTransactionWrapper() {
        return Optional.ofNullable(this.transactionWrapper);
    }

    public Optional<MongockImporterModule> getMongockLegacyImporterModule() {
        return Optional.ofNullable(this.mongockImporter);
    }
}

