/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.mongodb.springdata.v3.internal.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import io.flamingock.oss.driver.common.mongodb.CollectionWrapper;
import io.flamingock.oss.driver.common.mongodb.DocumentWrapper;
import io.flamingock.oss.driver.mongodb.springdata.v3.internal.mongodb.SpringDataMongoV3DocumentWrapper;
import org.bson.Document;
import org.bson.conversions.Bson;

public class SpringDataMongoV3CollectionWrapper
implements CollectionWrapper<SpringDataMongoV3DocumentWrapper> {
    private final MongoCollection<Document> collection;

    public SpringDataMongoV3CollectionWrapper(MongoCollection<Document> collection) {
        this.collection = collection;
    }

    public String getCollectionName() {
        return this.collection.getNamespace().getCollectionName();
    }

    public Iterable<DocumentWrapper> listIndexes() {
        return this.collection.listIndexes().map(SpringDataMongoV3DocumentWrapper::new);
    }

    public String createUniqueIndex(SpringDataMongoV3DocumentWrapper uniqueIndexDocument) {
        return this.collection.createIndex((Bson)uniqueIndexDocument.getDocument(), new IndexOptions().unique(true));
    }

    public void dropIndex(String indexName) {
        this.collection.dropIndex(indexName);
    }

    public void deleteMany(SpringDataMongoV3DocumentWrapper documentWrapper) {
        this.collection.deleteMany((Bson)documentWrapper.getDocument());
    }
}

