/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.mongodb.springdata.v3.internal;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.UpdateResult;
import io.flamingock.commons.utils.Result;
import io.flamingock.core.engine.audit.writer.AuditEntry;
import io.flamingock.core.engine.audit.writer.AuditStageStatus;
import io.flamingock.core.engine.local.Auditor;
import io.flamingock.oss.driver.common.mongodb.CollectionInitializator;
import io.flamingock.oss.driver.common.mongodb.CollectionWrapper;
import io.flamingock.oss.driver.common.mongodb.MongoDBAuditMapper;
import io.flamingock.oss.driver.mongodb.springdata.v3.internal.mongodb.SpringDataMongoV3CollectionWrapper;
import io.flamingock.oss.driver.mongodb.springdata.v3.internal.mongodb.SpringDataMongoV3DocumentWrapper;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongodb.ReadWriteConfiguration;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;

public class SpringDataMongoV3Auditor
implements Auditor {
    private static final Logger logger = LoggerFactory.getLogger(SpringDataMongoV3Auditor.class);
    private final MongoCollection<Document> collection;
    private final MongoDBAuditMapper<SpringDataMongoV3DocumentWrapper> mapper = new MongoDBAuditMapper(() -> new SpringDataMongoV3DocumentWrapper(new Document()));

    SpringDataMongoV3Auditor(MongoTemplate mongoTemplate, String collectionName, ReadWriteConfiguration readWriteConfiguration) {
        this.collection = mongoTemplate.getCollection(collectionName).withReadConcern(readWriteConfiguration.getReadConcern()).withReadPreference(readWriteConfiguration.getReadPreference()).withWriteConcern(readWriteConfiguration.getWriteConcern());
    }

    protected void initialize(boolean indexCreation) {
        CollectionInitializator initializer = new CollectionInitializator((CollectionWrapper)new SpringDataMongoV3CollectionWrapper(this.collection), () -> new SpringDataMongoV3DocumentWrapper(new Document()), new String[]{"executionId", "changeId", "state"});
        if (indexCreation) {
            initializer.initialize();
        } else {
            initializer.justValidateCollection();
        }
    }

    public Result writeEntry(AuditEntry auditEntry) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"executionId", (Object)auditEntry.getExecutionId()), Filters.eq((String)"changeId", (Object)auditEntry.getTaskId()), Filters.eq((String)"author", (Object)auditEntry.getAuthor())});
        Document entryDocument = ((SpringDataMongoV3DocumentWrapper)this.mapper.toDocument(auditEntry)).getDocument();
        UpdateResult result = this.collection.replaceOne(filter, (Object)entryDocument, new ReplaceOptions().upsert(true));
        logger.debug("SaveOrUpdate[{}] with result\n[upsertId:{}, matches: {}, modifies: {}, acknowledged: {}]", new Object[]{auditEntry, result.getUpsertedId(), result.getMatchedCount(), result.getModifiedCount(), result.wasAcknowledged()});
        return Result.OK();
    }

    public AuditStageStatus getAuditStageStatus() {
        AuditStageStatus.EntryBuilder builder = AuditStageStatus.entryBuilder();
        ((LinkedList)this.collection.find().into(new LinkedList())).stream().map(SpringDataMongoV3DocumentWrapper::new).map(arg_0 -> this.mapper.fromDocument(arg_0)).collect(Collectors.toList()).forEach(arg_0 -> ((AuditStageStatus.EntryBuilder)builder).addEntry(arg_0));
        return builder.build();
    }
}

