/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.mongodb.springdata.v3.internal;

import com.mongodb.TransactionOptions;
import io.flamingock.core.runtime.dependency.DependencyInjectable;
import io.flamingock.core.task.descriptor.TaskDescriptor;
import io.flamingock.core.task.navigation.step.FailedStep;
import io.flamingock.core.transaction.TransactionWrapper;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongodb.ReadWriteConfiguration;
import java.util.function.Supplier;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringDataMongoV3TransactionWrapper
implements TransactionWrapper {
    private final MongoTransactionManager txManager;

    SpringDataMongoV3TransactionWrapper(MongoTemplate mongoTemplate, ReadWriteConfiguration readWriteConfiguration) {
        this.txManager = new MongoTransactionManager(mongoTemplate.getMongoDatabaseFactory(), TransactionOptions.builder().readConcern(readWriteConfiguration.getReadConcern()).readPreference(readWriteConfiguration.getReadPreference()).writeConcern(readWriteConfiguration.getWriteConcern()).build());
    }

    public <T> T wrapInTransaction(TaskDescriptor taskDescriptor, DependencyInjectable dependencyInjectable, Supplier<T> operation) {
        TransactionStatus txStatus = this.getTxStatus((PlatformTransactionManager)this.txManager);
        T result = operation.get();
        if (result instanceof FailedStep) {
            this.txManager.rollback(txStatus);
        } else {
            this.txManager.commit(txStatus);
        }
        return result;
    }

    protected TransactionStatus getTxStatus(PlatformTransactionManager txManager) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("flamingock-transaction-spring-data-3");
        def.setPropagationBehavior(0);
        return txManager.getTransaction((TransactionDefinition)def);
    }
}

