/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.mongodb.sync.v4.driver;

import com.mongodb.client.MongoClient;
import io.flamingock.commons.utils.RunnerId;
import io.flamingock.core.configurator.core.CoreConfigurable;
import io.flamingock.core.configurator.local.LocalConfigurable;
import io.flamingock.core.engine.local.LocalConnectionEngine;
import io.flamingock.core.engine.local.driver.ConnectionDriver;
import io.flamingock.oss.driver.mongodb.sync.v4.MongoDBSync4Configuration;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.MongoSync4Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoSync4Driver
implements ConnectionDriver<MongoDBSync4Configuration> {
    private static final Logger logger = LoggerFactory.getLogger(MongoSync4Driver.class);
    private final MongoClient mongoClient;
    private final String databaseName;
    private MongoDBSync4Configuration driverConfiguration;

    @Deprecated
    public static MongoSync4Driver withLockStrategy(MongoClient mongoClient, String databaseName, @Deprecated long lockAcquiredForMillis, @Deprecated long lockQuitTryingAfterMillis, @Deprecated long lockTryFrequencyMillis) {
        MongoSync4Driver.logWarningFieldIgnored("lockAcquiredForMillis", lockAcquiredForMillis);
        MongoSync4Driver.logWarningFieldIgnored("lockQuitTryingAfterMillis", lockQuitTryingAfterMillis);
        MongoSync4Driver.logWarningFieldIgnored("lockTryFrequencyMillis", lockTryFrequencyMillis);
        return new MongoSync4Driver(mongoClient, databaseName);
    }

    @Deprecated
    public static MongoSync4Driver withDefaultLock(MongoClient mongoClient, String databaseName) {
        return new MongoSync4Driver(mongoClient, databaseName);
    }

    public MongoSync4Driver(MongoClient mongoClient, String databaseName) {
        this.mongoClient = mongoClient;
        this.databaseName = databaseName;
    }

    public MongoSync4Driver setDriverConfiguration(MongoDBSync4Configuration driverConfiguration) {
        this.driverConfiguration = driverConfiguration;
        return this;
    }

    public LocalConnectionEngine initializeAndGetEngine(RunnerId runnerId, CoreConfigurable coreConfiguration, LocalConfigurable communityConfiguration) {
        MongoSync4Engine engine = new MongoSync4Engine(this.mongoClient, this.databaseName, coreConfiguration, communityConfiguration, this.driverConfiguration != null ? this.driverConfiguration : MongoDBSync4Configuration.getDefault());
        engine.initialize(runnerId);
        return engine;
    }

    private static void logWarningFieldIgnored(String name, long value) {
        logger.warn("Parameter[{}] with value[{}] will be ignored. It needs to be injected in the configuration", (Object)name, (Object)value);
    }
}

