/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.mongodb.sync.v4.internal;

import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.UpdateResult;
import io.flamingock.commons.utils.Result;
import io.flamingock.community.internal.TransactionManager;
import io.flamingock.core.engine.audit.writer.AuditEntry;
import io.flamingock.core.engine.audit.writer.AuditStageStatus;
import io.flamingock.core.engine.local.Auditor;
import io.flamingock.oss.driver.common.mongodb.CollectionInitializator;
import io.flamingock.oss.driver.common.mongodb.CollectionWrapper;
import io.flamingock.oss.driver.common.mongodb.MongoDBAuditMapper;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongodb.MongoSync4CollectionWrapper;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongodb.MongoSync4DocumentWrapper;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongodb.ReadWriteConfiguration;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoSync4Auditor
implements Auditor {
    private static final Logger logger = LoggerFactory.getLogger(MongoSync4Auditor.class);
    private final MongoCollection<Document> collection;
    private final MongoDBAuditMapper<MongoSync4DocumentWrapper> mapper = new MongoDBAuditMapper(() -> new MongoSync4DocumentWrapper(new Document()));
    private final TransactionManager<ClientSession> sessionManager;

    MongoSync4Auditor(MongoDatabase database, String collectionName, ReadWriteConfiguration readWriteConfiguration, TransactionManager<ClientSession> sessionManager) {
        this.collection = database.getCollection(collectionName).withReadConcern(readWriteConfiguration.getReadConcern()).withReadPreference(readWriteConfiguration.getReadPreference()).withWriteConcern(readWriteConfiguration.getWriteConcern());
        this.sessionManager = sessionManager;
    }

    protected void initialize(boolean indexCreation) {
        CollectionInitializator initializer = new CollectionInitializator((CollectionWrapper)new MongoSync4CollectionWrapper(this.collection), () -> new MongoSync4DocumentWrapper(new Document()), new String[]{"executionId", "changeId", "state"});
        if (indexCreation) {
            initializer.initialize();
        } else {
            initializer.justValidateCollection();
        }
    }

    public Result writeEntry(AuditEntry auditEntry) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"executionId", (Object)auditEntry.getExecutionId()), Filters.eq((String)"changeId", (Object)auditEntry.getTaskId()), Filters.eq((String)"author", (Object)auditEntry.getAuthor())});
        Document entryDocument = ((MongoSync4DocumentWrapper)this.mapper.toDocument(auditEntry)).getDocument();
        UpdateResult result = this.sessionManager.getSession(auditEntry.getTaskId()).map(clientSession -> this.collection.replaceOne(clientSession, filter, (Object)entryDocument, new ReplaceOptions().upsert(true))).orElseGet(() -> this.collection.replaceOne(filter, (Object)entryDocument, new ReplaceOptions().upsert(true)));
        logger.debug("SaveOrUpdate[{}] with result\n[upsertId:{}, matches: {}, modifies: {}, acknowledged: {}]", new Object[]{auditEntry, result.getUpsertedId(), result.getMatchedCount(), result.getModifiedCount(), result.wasAcknowledged()});
        return Result.OK();
    }

    public AuditStageStatus getAuditStageStatus() {
        AuditStageStatus.EntryBuilder builder = AuditStageStatus.entryBuilder();
        ((LinkedList)this.collection.find().into(new LinkedList())).stream().map(MongoSync4DocumentWrapper::new).map(arg_0 -> this.mapper.fromDocument(arg_0)).collect(Collectors.toList()).forEach(arg_0 -> ((AuditStageStatus.EntryBuilder)builder).addEntry(arg_0));
        return builder.build();
    }
}

