/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.mongodb.sync.v4.internal;

import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.flamingock.commons.utils.RunnerId;
import io.flamingock.commons.utils.TimeService;
import io.flamingock.community.internal.LocalExecutionPlanner;
import io.flamingock.community.internal.TransactionManager;
import io.flamingock.community.internal.lock.LocalLockService;
import io.flamingock.core.configurator.core.CoreConfigurable;
import io.flamingock.core.configurator.local.LocalConfigurable;
import io.flamingock.core.engine.audit.AuditReader;
import io.flamingock.core.engine.audit.AuditWriter;
import io.flamingock.core.engine.local.Auditor;
import io.flamingock.core.engine.local.LocalConnectionEngine;
import io.flamingock.core.transaction.TransactionWrapper;
import io.flamingock.oss.driver.mongodb.sync.v4.MongoDBSync4Configuration;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.MongoSync4Auditor;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.MongoSync4LockService;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.MongoSync4TransactionWrapper;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongock.MongockImporterModule;
import java.util.Optional;
import org.bson.Document;

public class MongoSync4Engine
implements LocalConnectionEngine {
    private final MongoDatabase database;
    private final MongoClient mongoClient;
    private final LocalConfigurable localConfiguration;
    private MongoSync4Auditor auditor;
    private LocalExecutionPlanner executionPlanner;
    private TransactionWrapper transactionWrapper;
    private MongockImporterModule mongockImporter = null;
    private final MongoDBSync4Configuration driverConfiguration;
    private final CoreConfigurable coreConfiguration;

    public MongoSync4Engine(MongoClient mongoClient, String databaseName, CoreConfigurable coreConfiguration, LocalConfigurable localConfiguration, MongoDBSync4Configuration driverConfiguration) {
        this.mongoClient = mongoClient;
        this.database = mongoClient.getDatabase(databaseName);
        this.driverConfiguration = driverConfiguration;
        this.coreConfiguration = coreConfiguration;
        this.localConfiguration = localConfiguration;
    }

    public void initialize(RunnerId runnerId) {
        TransactionManager sessionManager = new TransactionManager(() -> ((MongoClient)this.mongoClient).startSession());
        this.transactionWrapper = this.coreConfiguration.getTransactionEnabled() != false ? new MongoSync4TransactionWrapper((TransactionManager<ClientSession>)sessionManager) : null;
        this.auditor = new MongoSync4Auditor(this.database, this.driverConfiguration.getMigrationRepositoryName(), this.driverConfiguration.getReadWriteConfiguration(), (TransactionManager<ClientSession>)sessionManager);
        this.auditor.initialize(this.driverConfiguration.isIndexCreation());
        MongoSync4LockService lockService = new MongoSync4LockService(this.database, this.driverConfiguration.getLockRepositoryName(), this.driverConfiguration.getReadWriteConfiguration(), TimeService.getDefault());
        lockService.initialize(this.driverConfiguration.isIndexCreation());
        this.executionPlanner = new LocalExecutionPlanner(runnerId, (LocalLockService)lockService, (AuditReader)this.auditor, this.coreConfiguration);
        if (this.coreConfiguration.isMongockImporterEnabled()) {
            MongoCollection collection = this.database.getCollection(this.coreConfiguration.getLegacyMongockChangelogSource());
            this.mongockImporter = new MongockImporterModule((MongoCollection<Document>)collection, (AuditWriter)this.auditor);
        }
    }

    public Auditor getAuditor() {
        return this.auditor;
    }

    public LocalExecutionPlanner getExecutionPlanner() {
        return this.executionPlanner;
    }

    public Optional<TransactionWrapper> getTransactionWrapper() {
        return Optional.ofNullable(this.transactionWrapper);
    }

    public Optional<MongockImporterModule> getMongockLegacyImporterModule() {
        return Optional.ofNullable(this.mongockImporter);
    }
}

