/*
 * Decompiled with CFR 0.152.
 */
package io.flamingock.oss.driver.mongodb.sync.v4.internal.mongock;

import com.mongodb.client.MongoCollection;
import io.flamingock.core.api.annotations.ChangeUnit;
import io.flamingock.core.api.annotations.Execution;
import io.flamingock.core.api.annotations.SystemChange;
import io.flamingock.core.engine.audit.AuditWriter;
import io.flamingock.core.engine.audit.legacy.mongock.ChangeEntry;
import io.flamingock.core.engine.audit.legacy.mongock.ChangeState;
import io.flamingock.core.engine.audit.legacy.mongock.ChangeType;
import io.flamingock.core.engine.audit.writer.AuditEntry;
import io.flamingock.core.legacy.MongockLegacyIdGenerator;
import io.flamingock.oss.driver.mongodb.sync.v4.internal.mongock.InternalMongockImporterConfiguration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;

@SystemChange
@ChangeUnit(id="mongock-local-legacy-importer-mongodb-3", order="1")
public class MongockLocalLegacyImporterChangeUnit {
    @Execution
    public void execution(InternalMongockImporterConfiguration configuration) {
        MongoCollection<Document> sourceCollection = configuration.getSourceCollection();
        if (sourceCollection == null) {
            throw new RuntimeException("AuditWriter not injected");
        }
        AuditWriter auditWriter = configuration.getAuditWriter();
        if (auditWriter == null) {
            throw new RuntimeException("AuditWriter not injected");
        }
        List<AuditEntry> collect = ((ArrayList)sourceCollection.find().into(new ArrayList())).stream().map(MongockLocalLegacyImporterChangeUnit::toChangeEntry).map(MongockLocalLegacyImporterChangeUnit::toAuditEntry).collect(Collectors.toList());
        collect.forEach(arg_0 -> ((AuditWriter)auditWriter).writeEntry(arg_0));
    }

    private static ChangeEntry toChangeEntry(Document document) {
        Date timestamp = document.getDate((Object)"timestamp");
        String id = MongockLegacyIdGenerator.getNewId((String)document.getString((Object)"changeId"), (String)document.getString((Object)"author"));
        return new ChangeEntry(document.getString((Object)"executionId"), id, document.getString((Object)"author"), timestamp, ChangeState.valueOf((String)document.getString((Object)"state")), ChangeType.valueOf((String)document.getString((Object)"type")), document.getString((Object)"changeLogClass"), document.getString((Object)"changeSetMethod"), document.get((Object)"metadata"), document.getLong((Object)"executionMillis").longValue(), document.getString((Object)"executionHostName"), document.getString((Object)"errorTrace"), document.getBoolean((Object)"systemChange"), timestamp);
    }

    private static AuditEntry toAuditEntry(ChangeEntry changeEntry) {
        LocalDateTime timestamp = Instant.ofEpochMilli(changeEntry.getTimestamp().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
        if (changeEntry.getState() == ChangeState.IGNORED) {
            return null;
        }
        return new AuditEntry(changeEntry.getExecutionId(), null, changeEntry.getChangeId(), changeEntry.getAuthor(), timestamp, changeEntry.getState().toAuditStatus(), changeEntry.getType().toAuditType(), changeEntry.getChangeLogClass(), changeEntry.getChangeSetMethod(), changeEntry.getExecutionMillis(), changeEntry.getExecutionHostname(), changeEntry.getMetadata(), changeEntry.getSystemChange().booleanValue(), changeEntry.getErrorTrace());
    }
}

